/*
 * Decompiled with CFR 0.152.
 */
package com.azul.openjdk.logcompilation;

import com.azul.jvm.compile.CompilationTier;
import com.azul.jvm.compile.CompilerId;

public enum CompilationLevel {
    LEVEL_0(0),
    LEVEL_1(1),
    LEVEL_2(2),
    LEVEL_3(3),
    LEVEL_4(4);

    private final int value;

    private CompilationLevel(int value) {
        this.value = value;
    }

    public int asInt() {
        return this.value;
    }

    public CompilationTier tier() {
        return this.value <= 3 ? CompilationTier.TIER_1 : CompilationTier.TIER_2;
    }

    public CompilerId compilerId() {
        return this.tier() == CompilationTier.TIER_1 ? CompilerId.C1 : CompilerId.C2;
    }

    public static CompilationLevel fromInt(int value) {
        for (CompilationLevel level : CompilationLevel.values()) {
            if (level.value != value) continue;
            return level;
        }
        throw new IllegalArgumentException("Unknown compilation level: " + value);
    }
}

