/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.compile2xlog.impl;

import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompileRelated;
import com.azul.jvm.compile.CompileStarted;
import com.azul.tools.compile2xlog.impl.CompileRelatedTransformer;
import com.azul.tools.compile2xlog.impl.LogWriter;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class CompileStartedTransformer
extends CompileRelatedTransformer
implements Function<CompilationId, CompileRelated> {
    private static final String TAG = "COMPILE_START";
    private final Map<CompilationId, CompileRelated> mapping = new HashMap<CompilationId, CompileRelated>(200000);

    public CompileStartedTransformer(LogWriter writer) {
        super(writer, TAG, "waitTimeMs");
    }

    public void process(CompileStarted compileStarted) {
        this.mapping.put(compileStarted.compileId, compileStarted);
        this.emitValues(compileStarted.time, compileStarted, Optional.ofNullable(compileStarted.waitTime).orElse(Duration.ZERO).toMillis());
    }

    @Override
    public CompileRelated apply(CompilationId id) {
        return this.mapping.get(id);
    }
}

