/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.profile2xlog.impl;

import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoader;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.tools.profile2xlog.impl.LogWriter;
import com.azul.zing.profilelog.ProfiledClassLoaderMatch;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ClassLoaderMatchTransformer {
    private static final String TAG = "CLASSLOADER_MATCH";
    private final LogWriter writer;
    private final Map<KlassLoaderId, ? extends KlassLoader> loaderById;
    private final Map<PersistentKlassId, KlassBuilder> klassById;

    public ClassLoaderMatchTransformer(LogWriter writer, Map<KlassLoaderId, ? extends KlassLoader> loaderById, Map<PersistentKlassId, KlassBuilder> klassById) {
        this.writer = writer;
        this.loaderById = Objects.requireNonNull(loaderById, "loaderById");
        this.klassById = Objects.requireNonNull(klassById, "klassById");
        writer.writeHeader(TAG, "loaderId", "oldLoaderId", "loaderType", "classId", "className", "tags", "matchType", "numMatches");
    }

    public void process(ProfiledClassLoaderMatch match) {
        KlassLoader klassLoader = this.loaderById.get(match.classLoaderId);
        if (klassLoader == null) {
            System.err.println("NO CLASSLOADER RECORD FOR " + match.classLoaderId + " in " + this.getClass().getSimpleName());
        } else {
            KlassBuilder klass = this.klassById.getOrDefault(klassLoader.loaderKlassId(), new KlassBuilder(PersistentKlassId.of(0)));
            String tags = klassLoader.tags().collect(Collectors.joining(",", "{", "}"));
            this.writer.writeLine(match.epochTime, TAG, new Object[]{klassLoader.id(), match.oldClassLoaderId, klassLoader.type(), klass.id(), klass.getName(), tags, match.matchType, match.numMatches});
        }
    }
}

