/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.profile2xlog.impl;

import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoader;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.jvm.time.EpochTime;
import com.azul.tools.profile2xlog.impl.LogWriter;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class ClassTransformer {
    private final String tag;
    private final LogWriter writer;
    private final Map<PersistentKlassId, KlassBuilder> klassById;
    private final Map<KlassLoaderId, ? extends KlassLoader> loaderById;
    private static final String[] fields = new String[]{"loaderId", "loaderType", "classId", "className"};

    public ClassTransformer(LogWriter writer, String tag, Map<PersistentKlassId, KlassBuilder> klassById, Map<KlassLoaderId, ? extends KlassLoader> loaderById, String ... extraFields) {
        this.tag = Objects.requireNonNull(tag, "tag");
        this.writer = Objects.requireNonNull(writer, "writer");
        this.klassById = Objects.requireNonNull(klassById, "klassById");
        this.loaderById = Objects.requireNonNull(loaderById, "loaderById");
        String[] allFields = (String[])Stream.of(fields, extraFields).flatMap(Stream::of).toArray(String[]::new);
        writer.writeHeader(tag, allFields);
    }

    protected final void emitValues(EpochTime time, PersistentKlassId klassId, Object ... extraValues) {
        KlassBuilder klass = this.klassById.get(klassId);
        if (klass == null) {
            System.err.println("NO CLASS RECORD FOR " + klassId + " in " + this.getClass().getSimpleName());
            return;
        }
        KlassLoaderId definingLoaderId = klass.getDefiningLoaderId();
        String loaderType = "N/A";
        KlassLoader loader = this.loaderById.get(definingLoaderId);
        if (loader == null) {
            System.err.println("NO CLASSLOADER RECORD FOR " + definingLoaderId + " in " + this.getClass().getSimpleName());
        } else {
            loaderType = loader.type().toString();
        }
        Object[] allValues = Stream.of({definingLoaderId, loaderType, klass.id(), klass.getName()}, extraValues).flatMap(Stream::of).toArray(Object[]::new);
        this.writer.writeLine(time, this.tag, allValues);
    }
}

