/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.profile2xlog.impl;

import com.azul.jvm.compile.CompilationBuilder;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.MethodBuilder;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.jvm.time.EpochTime;
import com.azul.tools.profile2xlog.impl.LogWriter;
import com.azul.zing.profilelog.CompileOptions;
import com.azul.zing.profilelog.ProfiledTier1Compilation;
import com.azul.zing.profilelog.ProfiledTier2Compilation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CompilationTransformer {
    private static final String TAG = "RN_COMPILE";
    private final String[] fields = new String[]{"tier", "compileId", "loaderId", "klassId", "klass", "method", "signature", "bci", "wave", "stashFlavour", "optLevel", "skipConstantLoading", "trySkipSignatureClassLoading", "priorityCompile", "evictableCompilation", "rnCompileId"};
    private final Map<CompilationId, CompilationBuilder> compileById;
    private final Map<PersistentMethodId, MethodBuilder> methodById;
    private final Map<PersistentKlassId, KlassBuilder> klassById;
    private final LogWriter writer;

    CompilationTransformer(LogWriter writer, Map<CompilationId, CompilationBuilder> compileById, Map<PersistentMethodId, MethodBuilder> methodById, Map<PersistentKlassId, KlassBuilder> klassById) {
        this.writer = Objects.requireNonNull(writer, "writer");
        this.compileById = Objects.requireNonNull(compileById, "compileById");
        this.methodById = Objects.requireNonNull(methodById, "methodById");
        this.klassById = Objects.requireNonNull(klassById, "klassById");
        writer.writeHeader(TAG, this.fields);
    }

    public void process(ProfiledTier1Compilation profiledTier1Compilation) {
        CompilationBuilder compilation = this.compileById.get(profiledTier1Compilation.compileId);
        if (compilation == null) {
            System.err.println("NO COMPILATION ENTRY FOR " + profiledTier1Compilation);
            return;
        }
        MethodBuilder method = this.methodById.get(profiledTier1Compilation.methodId);
        if (method == null) {
            System.err.println("NO METHOD ENTRY FOR " + profiledTier1Compilation);
            return;
        }
        KlassBuilder klass = this.klassById.get(method.klassId());
        if (klass == null) {
            System.err.println("NO CLASS ENTRY FOR " + profiledTier1Compilation);
            return;
        }
        this.emitValues(profiledTier1Compilation.epochTime, 1, compilation, method, klass, profiledTier1Compilation.compileOptions);
    }

    public void process(ProfiledTier2Compilation profiledTier2Compilation) {
        CompilationBuilder compilation = this.compileById.get(profiledTier2Compilation.compileId);
        if (compilation == null) {
            System.err.println("NO COMPILATION ENTRY FOR " + profiledTier2Compilation);
            return;
        }
        MethodBuilder method = this.methodById.get(profiledTier2Compilation.methodId);
        if (method == null) {
            System.err.println("NO METHOD ENTRY FOR " + profiledTier2Compilation);
            return;
        }
        KlassBuilder klass = this.klassById.get(method.klassId());
        if (klass == null) {
            System.err.println("NO CLASS ENTRY FOR " + profiledTier2Compilation);
            return;
        }
        this.emitValues(profiledTier2Compilation.epochTime, 2, compilation, method, klass, profiledTier2Compilation.compileOptions);
    }

    private void emitValues(EpochTime time, int tier, CompilationBuilder compilation, MethodBuilder method, KlassBuilder klass, CompileOptions options) {
        this.writer.writeLine(time, TAG, new Object[]{tier, compilation.id(), klass.getDefiningLoaderId(), klass.id(), klass.getName(), method.name(), method.signature(), Optional.ofNullable(compilation.osrBci()).orElse(-1), Character.valueOf(compilation.trigger().charValue()), Character.valueOf(compilation.stashFlavor().charValue()), compilation.optLevel(), options.skipConstantLoading, options.trySkipSignatureClassLoading, options.priorityCompile, options.evictableCompilation, options.rnCompileId});
    }
}

