/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.profile2xlog.impl;

import com.azul.jvm.compile.CompilationBuilder;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoader;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.jvm.method.MethodBuilder;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.tools.profile2xlog.impl.LogWriter;
import com.azul.zing.profilelog.ProfiledFirstCall;
import java.util.Map;
import java.util.Objects;

public class FirstCallTransformer {
    private static final String TAG = "FIRST_CALL";
    private final LogWriter writer;
    private final Map<KlassLoaderId, ? extends KlassLoader> loaderById;
    private final Map<PersistentKlassId, KlassBuilder> klassById;
    private final Map<CompilationId, CompilationBuilder> compilationById;
    private final Map<PersistentMethodId, MethodBuilder> methodById;

    public FirstCallTransformer(LogWriter writer, Map<KlassLoaderId, ? extends KlassLoader> loaderById, Map<PersistentKlassId, KlassBuilder> klassById, Map<CompilationId, CompilationBuilder> compilationById, Map<PersistentMethodId, MethodBuilder> methodById) {
        this.writer = Objects.requireNonNull(writer, "writer");
        this.loaderById = Objects.requireNonNull(loaderById, "loaderById");
        this.klassById = Objects.requireNonNull(klassById, "klassById");
        this.compilationById = Objects.requireNonNull(compilationById, "compilationById");
        this.methodById = Objects.requireNonNull(methodById, "methodById");
        writer.writeHeader(TAG, "loaderId", "loaderType", "classId", "className", "methodName", "methodSig", "threadId", "compilationId", "tier");
    }

    public void process(ProfiledFirstCall firstCall) {
        MethodBuilder method = this.methodById.get(firstCall.methodId);
        if (method == null) {
            System.err.println("NO METHOD RECORD FOR " + firstCall);
        }
        KlassBuilder klass = this.klassById.getOrDefault(method.klassId(), new KlassBuilder(method.klassId()));
        int tier = 0;
        if (firstCall.compileId.isValid()) {
            CompilationBuilder comp = this.compilationById.get(firstCall.compileId);
            if (comp == null) {
                System.err.println("NO COMPILATION RECORD FOR " + firstCall.compileId);
            } else {
                tier = comp.tier().intValue();
            }
        }
        KlassLoaderId definingLoaderId = klass.getDefiningLoaderId();
        String loaderType = "N/A";
        KlassLoader loader = this.loaderById.get(definingLoaderId);
        if (loader == null) {
            System.err.println("NO CLASSLOADER RECORD FOR " + definingLoaderId + " in " + this.getClass().getSimpleName());
        } else {
            loaderType = loader.type().toString();
        }
        this.writer.writeLine(firstCall.epochTime, TAG, definingLoaderId, loaderType, klass.id(), klass.getName(), method.name(), method.signature(), firstCall.threadId, firstCall.compileId, tier);
    }
}

