/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tools.profile2xlog.impl;

import com.azul.jvm.compile.CompilationBuilder;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.MethodBuilder;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.jvm.time.EpochTime;
import com.azul.tools.profile2xlog.impl.LogWriter;
import com.azul.zing.profilelog.ProfiledTier1Install;
import com.azul.zing.profilelog.ProfiledTier2Install;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class InstallTransformer {
    private static final String TAG = "RN_COMPILE_INSTALL";
    private final String[] fields = new String[]{"tier", "compileId", "loaderId", "klassId", "klass", "method", "signature", "blobSize", "cpuCompileTimeNs", "wallCompileTimeNs", "waitTimeNs", "success"};
    private final Map<CompilationId, CompilationBuilder> compileById;
    private final Map<PersistentMethodId, MethodBuilder> methodById;
    private final Map<PersistentKlassId, KlassBuilder> klassById;
    private final LogWriter writer;

    InstallTransformer(LogWriter writer, Map<CompilationId, CompilationBuilder> compileById, Map<PersistentMethodId, MethodBuilder> methodById, Map<PersistentKlassId, KlassBuilder> klassById) {
        this.writer = Objects.requireNonNull(writer, "writer");
        this.compileById = Objects.requireNonNull(compileById, "compileById");
        this.methodById = Objects.requireNonNull(methodById, "methodById");
        this.klassById = Objects.requireNonNull(klassById, "klassById");
        writer.writeHeader(TAG, this.fields);
    }

    public void process(ProfiledTier1Install profiledInstall) {
        CompilationBuilder compilation = this.compileById.get(profiledInstall.compileId);
        if (compilation == null) {
            System.err.println("NO COMPILATION ENTRY FOR " + profiledInstall);
            return;
        }
        MethodBuilder method = this.methodById.get(compilation.methodId());
        if (method == null) {
            System.err.println("NO METHOD ENTRY FOR " + profiledInstall);
            return;
        }
        KlassBuilder klass = this.klassById.get(method.klassId());
        if (klass == null) {
            System.err.println("NO CLASS ENTRY FOR " + profiledInstall);
            return;
        }
        InstallBuilder install = new InstallBuilder(profiledInstall.compileId);
        install.setBlobSize(profiledInstall.blobSize);
        install.setSuccess(profiledInstall.success);
        install.setCpuCompileTimeNs(profiledInstall.cpuCompileTimeNs);
        install.setWallCompileTimeNs(profiledInstall.wallCompileTimeNs);
        install.setWaitTimeNs(profiledInstall.waitTimeNs);
        this.emitValues(profiledInstall.epochTime, 1, install, klass, method);
    }

    public void process(ProfiledTier2Install profiledInstall) {
        CompilationBuilder compilation = this.compileById.get(profiledInstall.compileId);
        if (compilation == null) {
            System.err.println("NO COMPILATION ENTRY FOR " + profiledInstall);
            return;
        }
        MethodBuilder method = this.methodById.get(compilation.methodId());
        if (method == null) {
            System.err.println("NO METHOD ENTRY FOR " + profiledInstall);
            return;
        }
        KlassBuilder klass = this.klassById.get(method.klassId());
        if (klass == null) {
            System.err.println("NO CLASS ENTRY FOR " + profiledInstall);
            return;
        }
        InstallBuilder install = new InstallBuilder(profiledInstall.compileId);
        install.setBlobSize(profiledInstall.blobSize);
        install.setSuccess(profiledInstall.success);
        install.setCpuCompileTimeNs(profiledInstall.cpuCompileTimeNs);
        install.setWallCompileTimeNs(profiledInstall.wallCompileTimeNs);
        install.setWaitTimeNs(profiledInstall.waitTimeNs);
        this.emitValues(profiledInstall.epochTime, 2, install, klass, method);
    }

    protected final void emitValues(EpochTime time, int tier, InstallBuilder install, KlassBuilder klass, MethodBuilder method) {
        this.writer.writeLine(time, TAG, tier, install.compileId, klass.getDefiningLoaderId(), klass.id(), klass.getName(), method.name(), method.signature(), install.blobSize, Optional.ofNullable(install.cpuCompileTimeNs).orElse(-1L), Optional.ofNullable(install.wallCompileTimeNs).orElse(-1L), Optional.ofNullable(install.waitTimeNs).orElse(-1L), install.isSuccess());
    }

    class InstallBuilder {
        private CompilationId compileId;
        private long blobSize;
        private Long cpuCompileTimeNs;
        private Long wallCompileTimeNs;
        private Long waitTimeNs;
        private boolean success;

        public InstallBuilder(CompilationId compileId) {
            this.compileId = compileId;
        }

        public void setCompileId(CompilationId compileId) {
            this.compileId = compileId;
        }

        public long getBlobSize() {
            return this.blobSize;
        }

        public void setBlobSize(long blobSize) {
            this.blobSize = blobSize;
        }

        public Long getCpuCompileTimeNs() {
            return this.cpuCompileTimeNs;
        }

        public void setCpuCompileTimeNs(Long cpuCompileTimeNs) {
            this.cpuCompileTimeNs = cpuCompileTimeNs;
        }

        public Long getWallCompileTimeNs() {
            return this.wallCompileTimeNs;
        }

        public void setWallCompileTimeNs(Long wallCompileTimeNs) {
            this.wallCompileTimeNs = wallCompileTimeNs;
        }

        public Long getWaitTimeNs() {
            return this.waitTimeNs;
        }

        public void setWaitTimeNs(Long waitTimeNs) {
            this.waitTimeNs = waitTimeNs;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }
    }
}

