/*
 * Decompiled with CFR 0.152.
 */
package com.azul.xml.sax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class XmlPath {
    private final List<? extends PathPart> parts;
    private String cachedPathStr;

    public XmlPath() {
        this(Collections.emptyList(), "");
    }

    private XmlPath(List<? extends PathPart> parts, String cachedPathStr) {
        this.parts = parts;
        this.cachedPathStr = cachedPathStr;
    }

    public final XmlPath start(String uri, String local, String qName) {
        ArrayList<? extends PathPart> parts = new ArrayList<PathPart>(this.parts.size() + 1);
        parts.addAll(this.parts);
        parts.add(new PathPart(uri, local, qName));
        String cachedPathStr = this.cachedPathStr == null ? null : this.cachedPathStr + "/" + qName;
        return new XmlPath(parts, cachedPathStr);
    }

    public final XmlPath end() {
        int priorSlashIndex;
        String cachedPathStr = null;
        if (this.cachedPathStr != null && (priorSlashIndex = this.cachedPathStr.lastIndexOf(47)) != -1) {
            cachedPathStr = this.cachedPathStr.substring(0, priorSlashIndex);
        }
        return new XmlPath(this.parts.subList(0, this.parts.size() - 1), cachedPathStr);
    }

    public final boolean matches(String matchExpr) {
        if (matchExpr.startsWith("//")) {
            String affix = "/" + matchExpr.substring(2);
            return this.pathStr().endsWith(affix);
        }
        return this.pathStr().equals(matchExpr);
    }

    private String pathStr() {
        String pathStr;
        if (this.cachedPathStr != null) {
            return this.cachedPathStr;
        }
        StringBuilder builder = new StringBuilder();
        for (PathPart pathPart : this.parts) {
            builder.append('/').append(pathPart.qName);
        }
        this.cachedPathStr = pathStr = builder.toString();
        return pathStr;
    }

    public final String toString() {
        return this.pathStr();
    }

    private static final class PathPart {
        final String uri;
        final String local;
        final String qName;

        PathPart(String uri, String local, String qName) {
            this.uri = uri;
            this.local = local;
            this.qName = qName;
        }

        public final String toString() {
            return this.qName;
        }
    }
}

