/*
 * Decompiled with CFR 0.152.
 */
package com.azul.xml.sax.stack;

import com.azul.xml.sax.Attributes;
import com.azul.xml.sax.Characters;
import com.azul.xml.sax.stack.DefaultTagHandler;
import com.azul.xml.sax.stack.Tag;
import com.azul.xml.sax.stack.TagHandler;
import org.xml.sax.SAXException;

public final class LambdaTagHandler
extends DefaultTagHandler {
    private Attributes attributes;
    private Characters chars;
    private final Handler handler;
    private final ChildTagFactory childTagFactory;

    public LambdaTagHandler(Handler handler) {
        this.handler = handler;
        this.childTagFactory = null;
    }

    public LambdaTagHandler(Handler handler, ChildTagFactory childTagFactory) {
        this.handler = handler;
        this.childTagFactory = childTagFactory;
    }

    public LambdaTagHandler(AttributesOnlyHandler attribHandler) {
        this((Attributes attribs, Characters chars) -> attribHandler.process(attribs));
    }

    public LambdaTagHandler(AttributesOnlyHandler attribHandler, ChildTagFactory childFactory) {
        this((Attributes attribs, Characters chars) -> attribHandler.process(attribs), childFactory);
    }

    public LambdaTagHandler(CharsOnlyHandler charsHandler) {
        this((Attributes attribs, Characters chars) -> charsHandler.process(chars));
    }

    public LambdaTagHandler(CharsOnlyHandler charsHandler, ChildTagFactory childFactory) {
        this((Attributes attribs, Characters chars) -> charsHandler.process(chars), childFactory);
    }

    public LambdaTagHandler(MarkerHandler markerHandler) {
        this((Attributes attribs, Characters chars) -> markerHandler.process());
    }

    public LambdaTagHandler(MarkerHandler markerHandler, ChildTagFactory childFactory) {
        this((Attributes attribs, Characters chars) -> markerHandler.process(), childFactory);
    }

    @Override
    public void start(Tag tag, Attributes attributes) throws Exception {
        this.attributes = attributes;
    }

    @Override
    public TagHandler getChildTagHandler(Tag tag) throws Exception {
        return this.childTagFactory != null ? this.childTagFactory.getChildTagHandler(tag) : null;
    }

    @Override
    public void characters(Characters chars) throws Exception {
        if (chars.trim().isEmpty()) {
            return;
        }
        if (this.chars != null) {
            throw new SAXException("Expected a single char section");
        }
        this.chars = chars;
    }

    @Override
    public void end(Tag tag) throws Exception {
        this.handler.process(this.attributes, this.chars);
    }

    @FunctionalInterface
    public static interface ChildTagFactory {
        public TagHandler getChildTagHandler(Tag var1);
    }

    @FunctionalInterface
    public static interface MarkerHandler {
        public void process() throws Exception;
    }

    @FunctionalInterface
    public static interface CharsOnlyHandler {
        public void process(Characters var1) throws Exception;
    }

    @FunctionalInterface
    public static interface AttributesOnlyHandler {
        public void process(Attributes var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Handler {
        public void process(Attributes var1, Characters var2) throws Exception;
    }
}

