/*
 * Decompiled with CFR 0.152.
 */
package com.azul.xml.sax.stack;

import com.azul.xml.sax.Attributes;
import com.azul.xml.sax.Characters;
import com.azul.xml.sax.XmlPath;
import com.azul.xml.sax.stack.Tag;
import com.azul.xml.sax.stack.TagHandler;
import java.util.ArrayList;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public abstract class SaxStackHandler
extends DefaultHandler2 {
    private Locator charLocator = null;
    private Locator locator;
    private final ArrayList<TagHandler> handlerStack = new ArrayList();
    private final StringBuilder charBuilder = new StringBuilder();
    private XmlPath path = new XmlPath();

    public abstract TagHandler getRootTagHandler(Tag var1);

    public TagHandler getFallbackTagHandler() {
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public final void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
        this.path = this.path.start(uri, localName, qName);
        this.processCharacters();
        Tag tag = new Tag(uri, localName, qName);
        TagHandler newHandler = this.getNextHandler(tag);
        try {
            newHandler.start(tag, new Attributes(attributes));
        }
        catch (Exception e) {
            throw SaxStackHandler.createParseException(e, this.path, this.locator);
        }
        this.pushHandler(newHandler);
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.charLocator == null) {
            this.charLocator = this.locator;
        }
        this.charBuilder.append(ch, start, length);
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        this.processCharacters();
        Tag tag = new Tag(uri, localName, qName);
        TagHandler poppedHandler = this.popHandler();
        try {
            poppedHandler.end(tag);
        }
        catch (Exception e) {
            throw SaxStackHandler.createParseException(e, this.path, this.locator);
        }
        if (this.curHandler() != null) {
            try {
                this.curHandler().endChildTag(tag, poppedHandler);
            }
            catch (Exception e) {
                throw SaxStackHandler.createParseException(e, this.path, this.locator);
            }
        }
        this.path = this.path.end();
    }

    private void processCharacters() throws SAXException {
        TagHandler curHandler = this.curHandler();
        if (curHandler != null) {
            try {
                curHandler.characters(new Characters(this.charBuilder));
            }
            catch (Exception e) {
                throw SaxStackHandler.createParseException(e, this.path, this.charLocator);
            }
            finally {
                this.charBuilder.delete(0, this.charBuilder.length());
                this.charLocator = null;
            }
        }
    }

    private TagHandler curHandler() {
        if (this.handlerStack.isEmpty()) {
            return null;
        }
        return this.handlerStack.get(this.handlerStack.size() - 1);
    }

    private void pushHandler(TagHandler handler) {
        this.handlerStack.add(handler);
    }

    private TagHandler popHandler() {
        return this.handlerStack.remove(this.handlerStack.size() - 1);
    }

    private TagHandler getNextHandler(Tag tag) throws SAXException {
        TagHandler nextHandler = null;
        TagHandler curHandler = this.curHandler();
        if (curHandler == null) {
            nextHandler = this.getRootTagHandler(tag);
        } else {
            try {
                nextHandler = this.curHandler().getChildTagHandler(tag);
            }
            catch (Exception e) {
                throw SaxStackHandler.createParseException(e, this.path, this.locator);
            }
        }
        if (nextHandler == null) {
            nextHandler = this.getFallbackTagHandler();
        }
        if (nextHandler == null) {
            throw this.createParseException("Unexpected tag: " + tag, this.path, this.locator);
        }
        return nextHandler;
    }

    private SAXParseException createParseException(String msg, XmlPath path, Locator locator) {
        return new SAXParseException(msg + " @ " + path, locator);
    }

    private static SAXParseException createParseException(Exception cause, XmlPath path, Locator locator) {
        if (cause instanceof SAXParseException) {
            return (SAXParseException)cause;
        }
        return new SAXParseException(cause.getMessage() + " @ " + path, locator, cause);
    }
}

