/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.console.matchers;

import com.azul.gulp.text.Line;
import com.azul.gulp.text.RegexMatcher;
import com.azul.gulp.text.support.RegexLineMatcher;
import com.azul.jvm.MemoryAddress;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompileInstalled;
import com.azul.jvm.compile.CompilerId;

public final class PreludeCompilationInstallationLineMatcher
extends RegexLineMatcher<CompileInstalled> {
    public PreludeCompilationInstallationLineMatcher() {
        super("\\s*(\\d+)\\s+([123])\\s+installed at 0x([\\dabcdef]+) with size 0x([\\dabcdef]+)\\s+\\(\\s+([\\w\\d\\.\\:\\$\\<\\>\\/]*) waited\\s+(\\d+\\.\\d+) ms\\, compiled in\\s+(\\d+\\.\\d+) ms\\).*$");
    }

    @Override
    public CompileInstalled fromMatch(Line line, RegexMatcher matcher) throws Exception {
        CompilationId compileId = CompilationId.of(matcher.nextInt());
        int rawCompilerNum = matcher.nextInt();
        CompilerId compilerId = CompilerId.fromInt(rawCompilerNum);
        MemoryAddress address = MemoryAddress.of(matcher.nextLong(16));
        int size = matcher.nextInt(16);
        String methodName = matcher.nextString();
        double waitTimeMs = matcher.nextDouble();
        double compileTimeMs = matcher.nextDouble();
        return new CompileInstalled(compileId, compilerId, compilerId.tier(), methodName, address, size, waitTimeMs, compileTimeMs);
    }
}

