/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.jvm.klassloader.KlassLoaderBuilder;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.zing.profilelog.ProfileLogProcessor;
import com.azul.zing.profilelog.ProfiledClassLoader;
import com.azul.zing.profilelog.ProfiledClassLoaderTag;
import java.util.Map;
import java.util.Objects;

public class KlassLoaderModelBuilder
extends ProfileLogProcessor.Base {
    private final Map<KlassLoaderId, KlassLoaderBuilder> store;

    public KlassLoaderModelBuilder(Map<KlassLoaderId, KlassLoaderBuilder> store) {
        this.store = Objects.requireNonNull(store, "store");
    }

    @Override
    public void process(ProfiledClassLoader loader) {
        KlassLoaderBuilder builder = this.getOrAddKlassLoaderBuilder(loader.id);
        builder.setType(loader.loaderType);
        builder.setLoaderKlassId(loader.classId);
    }

    @Override
    public void process(ProfiledClassLoaderTag loaderTag) {
        this.getOrAddKlassLoaderBuilder(loaderTag.classLoaderId).addTag(loaderTag.tag);
    }

    private KlassLoaderBuilder getOrAddKlassLoaderBuilder(KlassLoaderId id) {
        return this.store.computeIfAbsent(id, KlassLoaderBuilder::new);
    }
}

