/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.jvm.method.MethodBuilder;
import com.azul.jvm.method.MethodSignature;
import com.azul.jvm.method.MethodUniqueness;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.zing.profilelog.ProfileLogProcessor;
import com.azul.zing.profilelog.ProfiledMethod;
import com.azul.zing.profilelog.ProfiledMethodUniqueness;
import java.util.Map;
import java.util.Objects;

public class MethodModelBuilder
extends ProfileLogProcessor.Base {
    private final Map<PersistentMethodId, MethodBuilder> store;

    public MethodModelBuilder(Map<PersistentMethodId, MethodBuilder> store) {
        this.store = Objects.requireNonNull(store, "store");
    }

    @Override
    public void process(ProfiledMethod method) {
        MethodBuilder builder = this.getOrAddMethodBuilder(method.id);
        builder.setKlassId(method.classId);
        builder.setName(method.shortName);
        builder.setSize(method.size);
        builder.setSignature(MethodSignature.of(method.sig));
    }

    @Override
    public void process(ProfiledMethodUniqueness uniqueness) {
        PersistentMethodId methodId = PersistentMethodId.of(uniqueness.methodId);
        MethodBuilder builder = this.getOrAddMethodBuilder(methodId);
        builder.addMethodUniqueness(new MethodUniqueness(uniqueness.callerClassId, uniqueness.calleeHolderClassId, uniqueness.receiverClassId, methodId, uniqueness.isMonomorphic));
    }

    private MethodBuilder getOrAddMethodBuilder(PersistentMethodId id) {
        return this.store.computeIfAbsent(id, MethodBuilder::new);
    }
}

