/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.Gulp;
import com.azul.gulp.text.GulpText;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.jvm.time.EpochTime;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;

@GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
@ProfileRecord(value="ClassLoaderMatch")
public final class ProfiledClassLoaderMatch {
    @Gulp.Capture
    public EpochTime epochTime;
    public final KlassLoaderId classLoaderId;
    public final KlassLoaderId oldClassLoaderId;
    public final MatchType matchType;
    public final int numMatches;

    @ProfileVersion(value=45)
    public ProfiledClassLoaderMatch(int classLoaderId, int oldClassLoaderId, int matchType, int numMatches) {
        this.classLoaderId = KlassLoaderId.of(classLoaderId);
        this.oldClassLoaderId = KlassLoaderId.of(oldClassLoaderId);
        this.matchType = MatchType.fromInt(matchType);
        this.numMatches = numMatches;
    }

    public final String toString() {
        return "ClassLoaderMatch: " + this.classLoaderId + " oldClassLoaderId: " + this.oldClassLoaderId + " matchType: " + this.matchType + " numMatches: " + this.numMatches;
    }

    public static enum MatchType {
        NONE(0),
        KNOWN(1),
        UNIQUE_CLASS(2);

        private final int matchType;

        private MatchType(int matchType) {
            this.matchType = matchType;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static MatchType fromInt(int matchType) {
            for (MatchType value : MatchType.values()) {
                if (value.matchType != matchType) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown MatchType " + matchType);
        }
    }
}

