/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.Gulp;
import com.azul.gulp.text.GulpText;
import com.azul.jvm.ThreadId;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.jvm.time.EpochTime;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;

@GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
@ProfileRecord(value="FirstCall")
public final class ProfiledFirstCall {
    @Gulp.Capture
    public EpochTime epochTime;
    public final PersistentMethodId methodId;
    public final ThreadId threadId;
    public final CompilationId compileId;

    @ProfileVersion(value=34)
    public ProfiledFirstCall(long methodId, long threadId, int compileId) {
        if (methodId == PersistentMethodId.INVALID.longValue()) {
            new Exception("no method for " + compileId).printStackTrace(System.err);
        }
        this.methodId = PersistentMethodId.of(methodId);
        this.threadId = ThreadId.of(threadId);
        this.compileId = CompilationId.of(compileId);
    }

    public String toString() {
        return "FirstCall: " + this.methodId + " thread:" + this.threadId + " compile: " + this.compileId;
    }
}

