/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog.internals;

import com.azul.gulp.Emitter;
import com.azul.jvm.codeprofile.KlassHistogram;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.zing.profilelog.ProfileHeader;
import com.azul.zing.profilelog.ProfiledInstruction;
import com.azul.zing.profilelog.internals.ProfileLineMatcher;
import java.util.ArrayList;

public final class ProfiledInvokeLineMatcher
extends ProfileLineMatcher<ProfiledInstruction.Invoke> {
    public ProfiledInvokeLineMatcher(Class<?> dataClass) {
        super(dataClass);
    }

    @Override
    protected void process(ProfileHeader header, ProfileLineMatcher.InputBuffer buffer, Emitter<ProfiledInstruction.Invoke> emitter) throws Exception {
        if (header.version >= 41) {
            this.processV41(buffer, emitter);
        } else if (header.version >= 26) {
            this.processV26(buffer, emitter);
        } else if (header.version >= 12) {
            this.processV12(buffer, emitter);
        } else {
            this.processV1(buffer, emitter);
        }
    }

    protected final void processV1(ProfileLineMatcher.InputBuffer buffer, Emitter<ProfiledInstruction.Invoke> emitter) throws Exception {
        long methodId = buffer.readLong();
        int compileId = buffer.readInt();
        int bci = buffer.readInt();
        int siteCount = buffer.readCount();
        int overflowCount = buffer.readCount();
        ArrayList<PersistentKlassId> classIds = new ArrayList<PersistentKlassId>(4);
        ArrayList<Integer> classCounts = new ArrayList<Integer>(4);
        buffer.readListStart();
        while (!buffer.isListEnd()) {
            buffer.readListStart();
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
            buffer.readListEnd();
        }
        buffer.readListEnd();
        while (!buffer.isEol()) {
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
        }
        emitter.fire(new ProfiledInstruction.Invoke(methodId, compileId, bci, siteCount, overflowCount, new KlassHistogram(classIds, classCounts)));
    }

    protected final void processV12(ProfileLineMatcher.InputBuffer buffer, Emitter<ProfiledInstruction.Invoke> emitter) throws Exception {
        long methodId = buffer.readLong();
        int compileId = buffer.readInt();
        int bci = buffer.readInt();
        int siteCount = buffer.readCount();
        int overflowCount = buffer.readCount();
        ArrayList<PersistentKlassId> classIds = new ArrayList<PersistentKlassId>(4);
        ArrayList<Integer> classCounts = new ArrayList<Integer>(4);
        buffer.readListStart();
        while (!buffer.isListEnd()) {
            buffer.readListStart();
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
            buffer.readListEnd();
        }
        buffer.readListEnd();
        while (!buffer.isEol()) {
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
        }
        emitter.fire(new ProfiledInstruction.Invoke(methodId, compileId, bci, siteCount, overflowCount, new KlassHistogram(classIds, classCounts)));
    }

    protected final void processV26(ProfileLineMatcher.InputBuffer buffer, Emitter<ProfiledInstruction.Invoke> emitter) {
        long profileId = buffer.readLong();
        int bci = buffer.readInt();
        int siteCount = buffer.readCount();
        int overflowCount = buffer.readCount();
        Long nestedProfileId = null;
        ArrayList<PersistentKlassId> classIds = new ArrayList<PersistentKlassId>(4);
        ArrayList<Integer> classCounts = new ArrayList<Integer>(4);
        buffer.readListStart();
        while (!buffer.isListEnd()) {
            buffer.readListStart();
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
            buffer.readListEnd();
        }
        buffer.readListEnd();
        if (!buffer.isEol()) {
            nestedProfileId = buffer.readLong();
        }
        emitter.fire(new ProfiledInstruction.Invoke(profileId, bci, siteCount, overflowCount, new KlassHistogram(classIds, classCounts), nestedProfileId));
    }

    protected final void processV41(ProfileLineMatcher.InputBuffer buffer, Emitter<ProfiledInstruction.Invoke> emitter) {
        long profileId = buffer.readLong();
        int bci = buffer.readInt();
        int siteCount = buffer.readCount();
        int abruptExitsCount = buffer.readCount();
        int overflowCount = buffer.readCount();
        Long nestedProfileId = null;
        ArrayList<PersistentKlassId> classIds = new ArrayList<PersistentKlassId>(4);
        ArrayList<Integer> classCounts = new ArrayList<Integer>(4);
        buffer.readListStart();
        while (!buffer.isListEnd()) {
            buffer.readListStart();
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
            buffer.readListEnd();
        }
        buffer.readListEnd();
        if (!buffer.isEol()) {
            nestedProfileId = buffer.readLong();
        }
        emitter.fire(new ProfiledInstruction.Invoke(profileId, bci, siteCount, abruptExitsCount, overflowCount, new KlassHistogram(classIds, classCounts), nestedProfileId));
    }
}

