/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.readynow;

public class CompilationState {
    public final State state;

    public CompilationState(int state) {
        this.state = this.decodeCompilationState(state);
    }

    public int getIntState() {
        return this.state.intValue();
    }

    public State decodeCompilationState(int state) {
        switch (state) {
            case 1: {
                return State.STARTED;
            }
            case 2: {
                return State.EVICTED;
            }
            case 3: {
                return State.REPLACED;
            }
            case 4: {
                return State.FLUSHED;
            }
            case 5: {
                return State.ENQUEUED;
            }
        }
        throw new IllegalArgumentException("Unknown value of state: " + state);
    }

    private static enum State {
        STARTED(1),
        EVICTED(2),
        REPLACED(3),
        FLUSHED(4),
        ENQUEUED(5),
        BAD(6);

        private final int i;

        private State(int i) {
            this.i = i;
        }

        public int intValue() {
            return this.i;
        }

        public static State fromInt(int id) {
            for (State value : State.values()) {
                if (value.i != id) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown state " + id);
        }

        public String toString() {
            return Integer.toString(this.i);
        }
    }
}

