/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.zvrobot;

import com.azul.zing.zvrobot.TickProfileFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ZVRobotDir {
    private static final String TICK_PROFILE_PREFIX = "TICKS_PROFILE_DEFAULTVIEW.";
    private static final String XML_EXTENSION = ".xml";
    private final File dir;

    public ZVRobotDir(String fileName) {
        this(new File(fileName));
    }

    public ZVRobotDir(File dir) {
        this.dir = dir;
    }

    public final List<TickProfileFile> listTickProfiles() {
        File[] overselectFiles = this.dir.listFiles((dir, name) -> name.startsWith(TICK_PROFILE_PREFIX) && name.endsWith(XML_EXTENSION));
        ArrayList<TickProfileFile> tickFiles = new ArrayList<TickProfileFile>(overselectFiles.length / 4);
        for (File file : overselectFiles) {
            int seqNum;
            String fileName = file.getName();
            String middle = fileName.substring(TICK_PROFILE_PREFIX.length(), fileName.length() - XML_EXTENSION.length());
            if (middle.contains("_")) continue;
            try {
                seqNum = Integer.parseInt(middle);
            }
            catch (NumberFormatException e) {
                continue;
            }
            tickFiles.add(new TickProfileFile(file, seqNum));
        }
        Collections.sort(tickFiles);
        return Collections.unmodifiableList(tickFiles);
    }
}

