/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.event;

public class MemoryPoolSummary {
    private final long occupancyBeforeCollection;
    private final long sizeBeforeCollection;
    private final long occupancyAfterCollection;
    private final long sizeAfterCollection;

    public MemoryPoolSummary(long occupancyBeforeCollection, long sizeBeforeCollection, long occupancyAfterCollection, long sizeAfterCollection) {
        this.occupancyBeforeCollection = occupancyBeforeCollection;
        this.sizeBeforeCollection = sizeBeforeCollection;
        this.occupancyAfterCollection = occupancyAfterCollection;
        this.sizeAfterCollection = sizeAfterCollection;
    }

    public MemoryPoolSummary(long occupancyBeforeCollection, long occupancyAfterCollection, long sizeAfterCollection) {
        this(occupancyBeforeCollection, sizeAfterCollection, occupancyAfterCollection, sizeAfterCollection);
    }

    public long getOccupancyBeforeCollection() {
        return this.occupancyBeforeCollection;
    }

    public long getOccupancyAfterCollection() {
        return this.occupancyAfterCollection;
    }

    public long getSizeBeforeCollection() {
        return this.sizeBeforeCollection;
    }

    public long getSizeAfterCollection() {
        return this.sizeAfterCollection;
    }

    public MemoryPoolSummary minus(MemoryPoolSummary memoryPoolSummary) {
        return new MemoryPoolSummary(this.getOccupancyBeforeCollection() - memoryPoolSummary.getOccupancyBeforeCollection(), this.getSizeBeforeCollection() - memoryPoolSummary.getSizeBeforeCollection(), this.getOccupancyAfterCollection() - memoryPoolSummary.getOccupancyAfterCollection(), this.getSizeAfterCollection() - memoryPoolSummary.getSizeAfterCollection());
    }

    public MemoryPoolSummary add(MemoryPoolSummary memoryPoolSummary) {
        return new MemoryPoolSummary(this.getOccupancyBeforeCollection() + memoryPoolSummary.getOccupancyBeforeCollection(), this.getSizeBeforeCollection() + memoryPoolSummary.getSizeBeforeCollection(), this.getOccupancyAfterCollection() + memoryPoolSummary.getOccupancyAfterCollection(), this.getSizeAfterCollection() + memoryPoolSummary.getSizeAfterCollection());
    }

    public long kBytesRecovered() {
        long kBytesRecovered = this.kByteDelta();
        return kBytesRecovered > 0L ? kBytesRecovered : 0L;
    }

    public long kBytesAllocated(MemoryPoolSummary previousHeapState) {
        long kBytesAllocated = this.occupancyBeforeCollection - previousHeapState.getOccupancyAfterCollection();
        return kBytesAllocated > 0L ? kBytesAllocated : 0L;
    }

    public long kByteDelta() {
        return this.occupancyBeforeCollection - this.occupancyAfterCollection;
    }

    public boolean isValid() {
        return this.sizeAfterCollection != -1L;
    }

    public String toString() {
        return this.occupancyBeforeCollection + "K(" + this.sizeBeforeCollection + "K)->" + this.occupancyAfterCollection + "K(" + this.sizeAfterCollection + "K)";
    }
}

