/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.event.jvm;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.time.DateTimeStamp;

public class SurvivorRecord
extends JVMEvent {
    private static final int THEORETICAL_MAX_TENURING_THRESHOLD = 15;
    private final long desiredOccupancyAfterCollection;
    private int calculatedTenuringThreshold;
    private int maxTenuringThreshold;
    private long[] bytesAtAge;

    public SurvivorRecord(DateTimeStamp timeStamp, long desiredOccupancy, int calculatedTenuringThreshold, int maxTenuringThreshold) {
        super(timeStamp, 0.0);
        this.desiredOccupancyAfterCollection = desiredOccupancy;
        this.setCalculatedThreshold(calculatedTenuringThreshold);
        this.setMaxTenuringThreshold(maxTenuringThreshold);
    }

    private void setMaxTenuringThreshold(int maxTenuringThresholdFromLog) {
        this.maxTenuringThreshold = maxTenuringThresholdFromLog <= 15 ? maxTenuringThresholdFromLog : 15;
    }

    private void setCalculatedThreshold(int calculatedTenuringThresholdFromLog) {
        this.calculatedTenuringThreshold = calculatedTenuringThresholdFromLog <= 15 ? calculatedTenuringThresholdFromLog : 15;
    }

    public long getDesiredOccupancyAfterCollection() {
        return this.desiredOccupancyAfterCollection;
    }

    public int getCalculatedTenuringThreshold() {
        return this.calculatedTenuringThreshold;
    }

    public int getMaxTenuringThreshold() {
        return this.maxTenuringThreshold;
    }

    public long getBytesAtAge(int age) {
        if (this.bytesAtAge == null) {
            return 0L;
        }
        return this.bytesAtAge[age];
    }

    public void add(int age, long bytes) {
        if (this.bytesAtAge == null) {
            this.bytesAtAge = new long[this.maxTenuringThreshold + 1];
            this.bytesAtAge[0] = 0L;
        }
        if (age <= this.maxTenuringThreshold) {
            this.bytesAtAge[age] = bytes;
        } else {
            int n = this.maxTenuringThreshold;
            this.bytesAtAge[n] = this.bytesAtAge[n] + bytes;
        }
    }

    public long[] getBytesAtEachAge() {
        if (this.bytesAtAge == null) {
            return new long[0];
        }
        return this.bytesAtAge;
    }
}

