/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.io;

import com.microsoft.gctoolkit.io.LogFileSegment;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Logger;
import java.util.stream.Stream;

public abstract class LogFileMetadata {
    private static final Logger LOG = Logger.getLogger(LogFileMetadata.class.getName());
    static final int GZIP_MAGIC1 = 31;
    static final int GZIP_MAGIC2 = 139;
    static final int ZIP_MAGIC1 = 80;
    static final int ZIP_MAGIC2 = 75;
    private FileFormat fileFormat = FileFormat.UNKNOWN;
    private final Path path;

    public LogFileMetadata(Path path) throws IOException {
        this.path = path;
        this.magic();
    }

    public Path getPath() {
        return this.path;
    }

    boolean magic(int field1, int field2) {
        boolean bl;
        FileInputStream magicByteReader = new FileInputStream(this.path.toFile());
        try {
            int magicByte1 = magicByteReader.read();
            int magicByte2 = magicByteReader.read();
            bl = magicByte1 == field1 && magicByte2 == field2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    magicByteReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                LOG.warning(ioe.getMessage());
                return false;
            }
        }
        magicByteReader.close();
        return bl;
    }

    public abstract Stream<LogFileSegment> logFiles();

    private void magic() {
        this.fileFormat = this.getPath().toFile().isDirectory() ? FileFormat.DIRECTORY : (this.magic(31, 139) ? FileFormat.GZIP : (this.magic(80, 75) ? FileFormat.ZIP : FileFormat.PLAINTEXT));
    }

    public abstract int getNumberOfFiles();

    public boolean isZip() {
        return this.fileFormat == FileFormat.ZIP;
    }

    public boolean isGZip() {
        return this.fileFormat == FileFormat.GZIP;
    }

    public boolean isPlainText() {
        return this.fileFormat == FileFormat.PLAINTEXT;
    }

    public boolean isDirectory() {
        return this.fileFormat == FileFormat.DIRECTORY;
    }

    static enum FileFormat {
        ZIP,
        GZIP,
        PLAINTEXT,
        DIRECTORY,
        UNKNOWN;

    }
}

