/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.jvm.MetaspaceRecord;
import com.microsoft.gctoolkit.parser.ForwardReference;
import com.microsoft.gctoolkit.parser.jvm.Decorators;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class GenerationalForwardReference
extends ForwardReference {
    private GarbageCollectionTypes gcType;
    private MemoryPoolSummary young = null;
    private MemoryPoolSummary tenured = null;
    private MemoryPoolSummary heap = null;
    private MetaspaceRecord metaspace = null;
    private MetaspaceRecord nonClassspace = null;
    private MetaspaceRecord classspace = null;
    private final Map<String, Double> remarkPhases = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> phases = new ConcurrentHashMap<String, Double>();

    public MetaspaceRecord getNonClassspace() {
        return this.nonClassspace;
    }

    public void setNonClassspace(MetaspaceRecord nonClassspace) {
        this.nonClassspace = nonClassspace;
    }

    public MetaspaceRecord getClassspace() {
        return this.classspace;
    }

    public void setClassspace(MetaspaceRecord classspace) {
        this.classspace = classspace;
    }

    public GenerationalForwardReference(GarbageCollectionTypes gcType, Decorators decorators, int gcid) {
        super(decorators, gcid);
        this.gcType = gcType;
    }

    GarbageCollectionTypes getGarbageCollectionType() {
        return this.gcType;
    }

    void setYoung(MemoryPoolSummary young) {
        this.young = young;
    }

    MemoryPoolSummary getYoung() {
        return this.young;
    }

    void setTenured(MemoryPoolSummary tenured) {
        this.tenured = tenured;
    }

    MemoryPoolSummary getTenured() {
        return this.tenured;
    }

    void setMetaspace(MetaspaceRecord metaSpaceRecord) {
        this.metaspace = metaSpaceRecord;
    }

    MetaspaceRecord getMetaspace() {
        return this.metaspace;
    }

    void setHeap(MemoryPoolSummary occupancyWithMemoryPoolSizeSummary) {
        this.heap = occupancyWithMemoryPoolSizeSummary;
    }

    MemoryPoolSummary getHeap() {
        return this.heap;
    }

    void addCMSRemarkPhase(String phase, double duration) {
        this.remarkPhases.put(phase, duration);
    }

    double getPhaseDuration(String phaseName) {
        return this.remarkPhases.get(phaseName);
    }

    Stream<String> remarkPhases() {
        return this.remarkPhases.keySet().stream();
    }

    public void convertToConcurrentModeFailure() {
        this.gcType = GarbageCollectionTypes.ConcurrentModeFailure;
    }

    public void convertToSerialFull() {
        this.gcType = GarbageCollectionTypes.FullGC;
    }

    public void addFullGCPhase(String phase, double duration) {
        this.phases.put(phase, duration);
    }
}

