/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.CPUSummary;
import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.ReferenceGCSummary;
import com.microsoft.gctoolkit.event.generational.AbortablePreClean;
import com.microsoft.gctoolkit.event.generational.BinaryTreeDictionary;
import com.microsoft.gctoolkit.event.generational.CMSConcurrentEvent;
import com.microsoft.gctoolkit.event.generational.CMSRemark;
import com.microsoft.gctoolkit.event.generational.ConcurrentMark;
import com.microsoft.gctoolkit.event.generational.ConcurrentModeFailure;
import com.microsoft.gctoolkit.event.generational.ConcurrentModeInterrupted;
import com.microsoft.gctoolkit.event.generational.ConcurrentPreClean;
import com.microsoft.gctoolkit.event.generational.ConcurrentReset;
import com.microsoft.gctoolkit.event.generational.ConcurrentSweep;
import com.microsoft.gctoolkit.event.generational.DefNew;
import com.microsoft.gctoolkit.event.generational.FullGC;
import com.microsoft.gctoolkit.event.generational.GenerationalGCPauseEvent;
import com.microsoft.gctoolkit.event.generational.InitialMark;
import com.microsoft.gctoolkit.event.generational.PSFullGC;
import com.microsoft.gctoolkit.event.generational.PSYoungGen;
import com.microsoft.gctoolkit.event.generational.ParNew;
import com.microsoft.gctoolkit.event.generational.ParNewPromotionFailed;
import com.microsoft.gctoolkit.event.generational.SystemGC;
import com.microsoft.gctoolkit.event.generational.YoungGC;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.ICMSPatterns;
import com.microsoft.gctoolkit.parser.JVMPatterns;
import com.microsoft.gctoolkit.parser.ParallelPatterns;
import com.microsoft.gctoolkit.parser.PreUnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.SerialPatterns;
import com.microsoft.gctoolkit.parser.SimplePatterns;
import com.microsoft.gctoolkit.parser.TenuredPatterns;
import com.microsoft.gctoolkit.parser.collection.MRUQueue;
import com.microsoft.gctoolkit.parser.unified.UnifiedG1GCPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenerationalHeapParser
extends PreUnifiedGCLogParser
implements SimplePatterns,
ICMSPatterns,
SerialPatterns,
ParallelPatterns {
    private static final Logger LOGGER = Logger.getLogger(GenerationalHeapParser.class.getName());
    private ParNew parNewForwardReference;
    private GarbageCollectionTypes garbageCollectionTypeForwardReference;
    private GCCause gcCauseForwardReference;
    private DateTimeStamp scavengeTimeStamp;
    private DateTimeStamp fullGCTimeStamp;
    private DateTimeStamp remarkTimeStamp;
    private MemoryPoolSummary youngMemoryPoolSummaryForwardReference;
    private MemoryPoolSummary tenuredForwardReference;
    private MemoryPoolSummary heapForwardReference;
    private MemoryPoolSummary metaSpaceForwardReference;
    private double scavengeDurationForwardReference;
    private ReferenceGCSummary referenceGCForwardReference;
    private CPUSummary scavengeCPUSummaryForwardReference;
    private int[] promotionFailureSizesForwardReference;
    private long totalFreeSpaceForwardReference;
    private long maxChunkSizeForwardReference;
    private int numberOfBlocksForwardReference;
    private long averageBlockSizeForwardReference;
    private int treeHeightForwardReference;
    private boolean expectRemark = false;
    private boolean inConcurrentPhase = false;
    private boolean abortPrecleanDueToTime = false;
    private final MRUQueue<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules = new MRUQueue();
    private final GCParseRule weakReferenceFragmentRule;
    private final GCParseRule cmsRemarkBlockRule;
    private DateTimeStamp startOfConcurrentPhase;
    private final ArrayList<GenerationalGCPauseEvent> queue;

    public GenerationalHeapParser() {
        this.parseRules.put(DEFNEW, this::defNew);
        this.parseRules.put(DEFNEW_TENURING, this::defNewWithTenuring);
        this.parseRules.put(SERIAL_FULL, this::serialFull);
        this.parseRules.put(PARNEW, this::parNew);
        this.parseRules.put(PARNEW_TENURING, this::parNewWithTenuring);
        this.parseRules.put(PARNEW_CONCURRENT_MODE_END, this::parNewConcurrentModeEnd);
        this.parseRules.put(PARNEW_CARDTABLE, this::parNewCardTable);
        this.parseRules.put(PARNEW_TO_CMF_PERM, this::parNewToConcurrentModeFailure);
        this.parseRules.put(PARNEW_TO_CMF_META, this::parNewToConcurrentModeFailure);
        this.parseRules.put(PARNEW_REFERENCE, this::parNewReference);
        this.parseRules.put(PARNEW_REFERENCE_SPLIT, this::parNewReferenceSplit);
        this.parseRules.put(JVMPatterns.TLAB_START, this::gcSplitByTLAB);
        this.parseRules.put(PARNEW_REFERENCE_SPLIT_BY_TLAB, this::parNewReferenceSplitByTLAB);
        this.parseRules.put(DEFNEW_REFERENCE, this::defNewReference);
        this.parseRules.put(PARNEW_PROMOTION_FAILED, this::parNewPromotionFailed);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_DETAILS, this::parNewPromotionFailedDetails);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_REFERENCE, this::parNewPromotionFailedReference);
        this.parseRules.put(FLOATING_REFERENCE, this::parNewFloatingReference);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_TENURING, this::parNewPromotionFailedTenuring);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_IN_CMS_PHASE, this::parNewPromotionFailedInConcurrentMarkSweepPhase);
        this.parseRules.put(CMS_BAILING_TO_FOREGROUND, this::concurrentMarkSweepBailingToForeground);
        this.parseRules.put(PROMOTION_FAILED_TO_FULL, this::promotionFailedToFull);
        this.parseRules.put(PARNEW_PLAB, this::parNewPLAB);
        this.parseRules.put(PLAB_ENTRY, this::plabEntry);
        this.parseRules.put(PLAB_SUMMARY, this::plabSummary);
        this.parseRules.put(FULLGC_FLS_BEFORE, this::fullGCFLSBefore);
        this.parseRules.put(PARNEW_FLS_BEFORE, this::parNewFLSBefore);
        this.parseRules.put(PARNEW_FLS_AFTER, this::parNewFLSAfter);
        this.parseRules.put(PARNEW_FLS_BODY, this::parNewFLSBody);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_DETAILS_AFTER, this::parNewConcurrentModeFailureFLSAfter);
        this.parseRules.put(PARNEW_FLS_TIME, this::parNewFLSTime);
        this.parseRules.put(FLS_HEADER, this::parNewFLSHeader);
        this.parseRules.put(FLS_SEPARATOR, this::parNewFLSSeparator);
        this.parseRules.put(FLS_TOTAL_FREE_SPACE, this::parNewFLSTotalFreeSpace);
        this.parseRules.put(FLS_MAX_CHUNK_SIZE, this::parNewFLSMaxChunkSize);
        this.parseRules.put(FLS_NUMBER_OF_BLOCKS, this::parNewFLSNumberOfBlocks);
        this.parseRules.put(FLS_AVERAGE_BLOCK_SIZE, this::parNewFLSAveBlockSize);
        this.parseRules.put(FLS_TREE_HEIGHT, this::parNewFLSTreeHeight);
        this.parseRules.put(FLS_LARGE_BLOCK_PROXIMITY, this::flsLargeBlockProximity);
        this.parseRules.put(FLS_LARGE_BLOCK, this::flsLargeBlock);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_TIME_ABORT_PRECLEAN, this::parNewPromotionFailedTimeAbortPreclean);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_CONCURRENT_PHASE, this::parNewPromotionFailedConcurrentPhase);
        this.parseRules.put(CORRUPTED_PARNEW_CONCURRENT_PHASE, this::corruptedParNewConcurrentPhase);
        this.parseRules.put(CORRUPTED_PARNEW_BODY, this::corruptedParNewBody);
        this.parseRules.put(CONCURRENT_PHASE_START, this::concurrentPhaseStart);
        this.parseRules.put(CONCURRENT_PHASE_END, this::concurrentPhaseEnd);
        this.parseRules.put(CONCURRENT_PHASE_END_WITH_CPU_SUMMARY, this::concurrentPhaseEnd);
        this.parseRules.put(INITIAL_MARK, this::initialMark);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK, this::scavengeBeforeRemark);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK_TENURING, this::scavengeBeforeRemarkTenuring);
        this.parseRules.put(PARALLEL_REMARK_WEAK_REF, this::recordRemark);
        this.parseRules.put(PARALLEL_REMARK_CLASS_UNLOADING, this::recordRemark);
        this.parseRules.put(REMARK_PARNEW_PROMOTION_FAILED, this::remarkParNewPromotionFailed);
        this.parseRules.put(PARALLEL_REMARK_STRING_SYMBOL, this::parallelRemarkStringSymbolClause);
        this.parseRules.put(PARALLEL_REMARK_WEAK_CLASS_SYMBOL_STRING, this::recordRemark);
        this.parseRules.put(PARALLEL_REMARK_WEAK_STRING, this::recordRemark);
        this.parseRules.put(PARALLEL_RESCAN, this::parallelRescan);
        this.parseRules.put(REMARK, this::recordRemark);
        this.parseRules.put(PARALLEL_RESCAN_V2, this::recordRemark);
        this.parseRules.put(PARALLEL_RESCAN_WEAK_CLASS_SCRUB, this::recordRemark);
        this.parseRules.put(SERIAL_REMARK_SCAN_BREAKDOWNS, this::recordRemark);
        this.parseRules.put(REMARK_DETAILS, this::recordRemark);
        this.parseRules.put(REMARK_REFERENCE_PROCESSING, this::recordRemarkWithReferenceProcessing);
        this.parseRules.put(TENURING_DETAILS, this::tenuringDetails);
        this.parseRules.put(RESCAN_WEAK_CLASS_SYMBOL_STRING, this::rescanWeakClassSymbolString);
        this.parseRules.put(CONCURRENT_MODE_FAILURE_DETAILS, this::concurrentModeFailureDetails);
        this.parseRules.put(CONCURRENT_MODE_FAILURE_DETAILS_META, this::concurrentModeFailureDetails);
        this.parseRules.put(PARNEW_DETAILS_CONCURRENT_MODE_FAILURE_PERM, this::parNewDetailsConcurrentModeFailure);
        this.parseRules.put(PARNEW_DETAILS_CONCURRENT_MODE_FAILURE_META, this::parNewDetailsConcurrentModeFailure);
        this.parseRules.put(PARNEW_DETAILS_PROMOTION_FAILED_WITH_CMS_PHASE, this::parNewDetailsPromotionFailedWithConcurrentMarkSweepPhase);
        this.parseRules.put(PARNEW_DETAILS_WITH_CONCURRENT_MODE_FAILURE, this::parNewDetailsWithConcurrentModeFailure);
        this.parseRules.put(CONCURRENT_MODE_FAILURE_REFERENCE, this::concurrentModeFailureReference);
        this.parseRules.put(iCMS_CONCURRENT_MODE_FAILURE, this::iCMSConcurrentModeFailure);
        this.parseRules.put(iCMS_CONCURRENT_MODE_FAILURE_META, this::iCMSConcurrentModeFailure);
        this.parseRules.put(iCMS_CMF_DUIRNG_PARNEW_DEFNEW_DETAILS, this::iCMSConcurrentModeFailureDuringParNewDefNewDetails);
        this.parseRules.put(FULL_GC_INTERRUPTS_CONCURRENT_PHASE, this::fullGCInterruptsConcurrentPhase);
        this.parseRules.put(FULL_PARNEW_START, this::fullParNewStart);
        this.parseRules.put(CMS_FULL_80, this::psFullReferenceJDK8);
        this.parseRules.put(FULL_GC_REFERENCE_CMF, this::fullGCReferenceConcurrentModeFailure);
        this.parseRules.put(iCMS_PARNEW, this::iCMSParNew);
        this.parseRules.put(iCMS_PARNEW_PROMOTION_FAILURE_RECORD, this::iCMSParNewPromotionFailureRecord);
        this.parseRules.put(iCMS_PARNEW_PROMOTION_FAILURE, this::iCMSParNewPromotionFailure);
        this.parseRules.put(FULL_GC_ICMS, this::fullGCiCMS);
        this.parseRules.put(iCMS_PARNEW_DEFNEW_TENURING_DETAILS, this::iCMSParNewDefNewTenuringDetails);
        this.parseRules.put(iCMS_FULL, this::iCMSFullGC);
        this.parseRules.put(iCMS_PROMOTION_FAILED, this::iCMSPromotionFailed);
        this.parseRules.put(iCMS_MISLABELED_FULL, this::iCMSMislabeledFull);
        this.parseRules.put(iCMS_FULL_AFTER_CONCURRENT_MODE_FAILURE, this::iCMSFullAfterConcurrentModeFailure);
        this.parseRules.put(iCMS_FULL_AFTER_CONCURRENT_MODE_FAILURE_META, this::iCMSFullAfterConcurrentModeFailure);
        this.parseRules.put(iCMS_CONCURRENT_MODE_INTERRUPTED, this::iCMSConcurrentModeInterrupted);
        this.parseRules.put(PS_FULL_GC_META, this::psFullGCMeta);
        this.parseRules.put(PS_FULL_GC_V2_META, this::psFullGCV2Meta);
        this.parseRules.put(CMS_FULL_META, this::cmsFullPermOrMeta);
        this.parseRules.put(FULL_PARNEW_CMF_META, this::fullParNewConcurrentModeFailureMeta);
        this.parseRules.put(FULL_PARNEW_CMF_PERM, this::fullParNewConcurrentModeFailurePerm);
        this.parseRules.put(PARNEW_CONCURRENT_MODE_FAILURE_PERM, this::parNewConcurrentModeFailurePerm);
        this.parseRules.put(PARNEW_CONCURRENT_MODE_FAILURE_META, this::parNewConcurrentModeFailurePerm);
        this.parseRules.put(PS_FULL_GC_V2_PERM, this::psFullGCV2Perm);
        this.parseRules.put(PS_FULL_GC_PERM, this::psFullGCPerm);
        this.parseRules.put(CMS_FULL_PERM, this::cmsFullPermOrMeta);
        this.parseRules.put(CMS_FULL_PERM_META_REFERENCE, this::cmsFullPermOrMeta);
        this.parseRules.put(PARNEW_NO_DETAILS, this::parNewNoDetails);
        this.parseRules.put(YOUNG_NO_DETAILS, this::youngNoDetails);
        this.parseRules.put(CMS_NO_DETAILS, this::cmsNoDetails);
        this.parseRules.put(FULL_NO_GC_DETAILS, this::fullNoGCDetails);
        this.parseRules.put(PARNEW_START, this::parNewStart);
        this.parseRules.put(GC_START, this::gcStart);
        this.parseRules.put(YOUNG_SPLIT_NO_DETAILS, this::youngSplitNoDetails);
        this.parseRules.put(CMF_SIMPLE, this::cmfSimple);
        this.parseRules.put(DEFNEW_DETAILS, this::defNewDetails);
        this.parseRules.put(PRECLEAN_REFERENCE_PAR_NEW_REFERENCE, this::preCleanReferenceParNewReference);
        this.parseRules.put(PSYOUNGGEN, this::psYoungGen);
        this.parseRules.put(PSYOUNGGEN_PROMOTION_FAILED, this::psYoungGen);
        this.parseRules.put(PSFULL, this::psFull);
        this.parseRules.put(PSYOUNGGEN_NO_DETAILS, this::psYoungNoDetails);
        this.parseRules.put(PSYOUNGGEN_REFERENCE_SPLIT, this::psYoungGenReferenceProcessingSplit);
        this.parseRules.put(PSYOUNGGEN_REFERENCE, this::psYoungGenReferenceProcessing);
        this.parseRules.put(PS_TENURING_START, this::psTenuringStart);
        this.parseRules.put(PSFULL_SPLIT, this::psFullSPlit);
        this.parseRules.put(PS_FULL_REFERENCE_SPLIT, this::psFullReferenceSplit);
        this.parseRules.put(PS_FULL_REFERENCE, this::psFullReference);
        this.parseRules.put(PS_DETAILS_WITH_TENURING, this::psDetailsWithTenuring);
        this.parseRules.put(PS_FAILURE, this::psFailure);
        this.parseRules.put(PSYOUNG_ADAPTIVE_SIZE_POLICY, this::psYoungAdaptiveSizePolicy);
        this.parseRules.put(PSOLD_ADAPTIVE_SIZE_POLICY, this::psFullAdaptiveSizePolicy);
        this.parseRules.put(PSYOUNG_DETAILS_FLOATING, this::psYoungDetailsFloating);
        this.parseRules.put(PSFULL_ADAPTIVE_SIZE, this::psFullAdaptiveSize);
        this.parseRules.put(PS_FULL_BODY_FLOATING, this::psFullBodyFloating);
        this.parseRules.put(FULL_REFERENCE_ADAPTIVE_SIZE, this::psFullReferenceAdaptiveSize);
        this.parseRules.put(PS_PROMOTION_FAILED, this::psPromotionFailed);
        this.parseRules.put(RESCAN_SPLIT_UNLOADING_STRING, this::rescanSplitUnloadingString);
        this.parseRules.put(PARNEW_CONCURRENT_PHASE_CARDS, this::parNewConcurrentPhaseCards);
        this.parseRules.put(CONC_PHASE_YIELDS, this::concurrentPhaseYields);
        this.parseRules.put(PRECLEAN_TIMED_OUT_WITH_CARDS, this::precleanTimedoutWithCards);
        this.parseRules.put(PARNEW_SHOULD_CONCURRENT_COLLECT, this::parNewShouldConcurrentCollect);
        this.parseRules.put(SHOULD_CONCURRENT_COLLECT, this::shouldCollectConcurrent);
        this.parseRules.put(REMARK_SPLIT_BY_DEBUG, this::remarkSplitByDebug);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK_PRINT_HEAP_AT_GC, this::scavengeBeforeRemarkPrintHeapAtGC);
        this.parseRules.put(SPLIT_REMARK_REFERENCE_BUG, this::splitRemarkReferenceWithWeakReferenceSplitBug);
        this.parseRules.put(SPLIT_REMARK_REFERENCE, this::splitRemarkReference);
        this.parseRules.put(PSYOUNG_ADAPTIVE_SIZE_POLICY_START, this::psYoungAdaptivePolicySizeStart);
        this.parseRules.put(PS_ADAPTIVE_SIZE_POLICY_BODY, this::psYoungAdaptivePolicySizeBody);
        this.parseRules.put(ADAPTIVE_SIZE_POLICY_BODY, this::adaptivePolicySizeBody);
        this.parseRules.put(ADAPTIVE_SIZE_POLICY_STOP, this::adaptiveSizePolicyStop);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK_REFERENCE, this::scavengeBeforeRemarkReference);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK_REFERENCE_SPLIT, this::scavengeBeforeRemarkReferenceSplit);
        this.parseRules.put(PARNEW_TO_CONCURRENT_MODE_FAILURE, this::parNewToPsudoConcurrentModeFailure);
        this.parseRules.put(SERIAL_FULL_REFERENCE, this::serialFullReference);
        this.parseRules.put(PSFULL_ERGONOMICS_PHASES, this::psFullErgonomicsPhases);
        this.parseRules.put(PSFULL_REFERENCE_PHASE, this::psFullReferencePhase);
        this.parseRules.put(SPLIT_PARNEW_PROMOTION_FAILED_IN_CMS_PHASE, this::parNewPromotionFailedInConcurrentMarkSweepPhase);
        this.parseRules.put(FULL_SPLIT_BY_CONCURRENT_PHASE, this::fullSplitByConcurrentPhase);
        this.parseRules.put(CMF_LARGE_BLOCK, this::concurrentModeFailureSplitByLargeBlock);
        this.parseRules.put(UnifiedG1GCPatterns.WEAK_PROCESSING, this::noop);
        this.parseRules.put(ABORT_PRECLEAN_DUE_TO_TIME_CLAUSE, this::abortPrecleanDueToTime);
        this.parseRules.put(CONCURRENT_PHASE_CARDS, this::abortPrecleanWithCards);
        this.parseRules.put(PRECLEAN_REFERENCE, this::endConcurrentPrecleanWithReferenceProcessing);
        this.parseRules.put(new GCParseRule("FLOATING_CPU_BREAKOUT", "^\\[Times: user=(\\d+(?:\\.|,)\\d+) sys=(\\d+(?:\\.|,)\\d+), real=(-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)\\]"), this::noop);
        this.parseRules.put(new GCParseRule("END_OF_DATA_SENTINEL", "END_OF_DATA_SENTINEL"), this::endOfFile);
        this.weakReferenceFragmentRule = new GCParseRule("weakReferenceFragmentRule", "\\], (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)");
        this.cmsRemarkBlockRule = new GCParseRule("CMS_REMARK_BLOCK", "\\[1 CMS-remark: (\\d+)([B,K,M,G])\\((\\d+)([B,K,M,G])\\)\\] (\\d+)([B,K,M,G])\\((\\d+)([B,K,M,G])\\), (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)\\]");
        this.queue = new ArrayList();
    }

    @Override
    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.GENERATIONAL);
    }

    @Override
    public String getName() {
        return "GenerationalHeapParser";
    }

    @Override
    protected void process(String line) {
        if (this.ignoreFrequentButUnwantedEntries(line)) {
            return;
        }
        try {
            Optional<AbstractMap.SimpleEntry> optional = this.parseRules.keys().stream().map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(line))).filter(tuple -> tuple.getValue() != null).findFirst();
            if (optional.isPresent()) {
                AbstractMap.SimpleEntry ruleAndTrace = optional.get();
                this.parseRules.get(ruleAndTrace.getKey()).accept((GCLogTrace)ruleAndTrace.getValue(), line);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "process", t);
        }
        this.log(line);
    }

    private boolean ignoreFrequentButUnwantedEntries(String line) {
        if (JVMPatterns.APPLICATION_TIME.parse(line) != null) {
            return true;
        }
        if (JVMPatterns.SIMPLE_APPLICATION_TIME.parse(line) != null) {
            return true;
        }
        if (JVMPatterns.APPLICATION_STOP_TIME.parse(line) != null) {
            return true;
        }
        if (JVMPatterns.APPLICATION_STOP_TIME_WITH_STOPPING_TIME.parse(line) != null) {
            return true;
        }
        if (JVMPatterns.SIMPLE_APPLICATION_STOP_TIME.parse(line) != null) {
            return true;
        }
        if (TenuredPatterns.TENURING_SUMMARY.parse(line) != null) {
            return true;
        }
        if (TenuredPatterns.TENURING_AGE_BREAKDOWN.parse(line) != null) {
            return true;
        }
        if (line.startsWith("TLAB: gc thread: ")) {
            return true;
        }
        if (line.startsWith("TLAB totals: thrds: ")) {
            return true;
        }
        if (line.startsWith("{Heap before")) {
            return true;
        }
        if (line.equals("}")) {
            return true;
        }
        if (line.startsWith("Heap")) {
            return true;
        }
        if (line.startsWith("Heap after")) {
            return true;
        }
        if (line.startsWith("PSYoungGen")) {
            return true;
        }
        if (line.startsWith("ParOldGen")) {
            return true;
        }
        if (line.startsWith("PSOldGen")) {
            return true;
        }
        if (line.startsWith("PSPermGen")) {
            return true;
        }
        if (line.startsWith("concurrent mark-sweep")) {
            return true;
        }
        if (line.startsWith("object space")) {
            return true;
        }
        if (line.startsWith("eden space")) {
            return true;
        }
        if (line.startsWith("from space")) {
            return true;
        }
        if (line.startsWith("to   space")) {
            return true;
        }
        if (line.contains("[0xffff") && line.endsWith("000)")) {
            return true;
        }
        if (line.startsWith("Finished ")) {
            return true;
        }
        if (line.startsWith("GC locker: Trying a full collection because scavenge failed")) {
            return true;
        }
        if (line.startsWith("Java HotSpot(TM)")) {
            return true;
        }
        if (line.startsWith("OpenJDK 64")) {
            return true;
        }
        if (line.startsWith("Memory: ")) {
            return true;
        }
        if (line.startsWith("CommandLine flags: ")) {
            return true;
        }
        if (line.startsWith("/proc/meminfo")) {
            return true;
        }
        return line.startsWith("avg_survived_padded_avg");
    }

    public void endOfFile(GCLogTrace trace, String line) {
        this.publish(new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()), true);
    }

    public void defNew(GCLogTrace trace, String line) {
        DefNew defNew = new DefNew(this.getClock(), trace.gcCause(), trace.getDuration());
        defNew.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(13), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 20));
        defNew.add(this.extractCPUSummary(line));
        this.publish(defNew);
    }

    public void defNewDetails(GCLogTrace trace, String line) {
        DefNew defNew = new DefNew(this.getClock(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 58);
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(51);
        defNew.add(young, heap.minus(young), heap);
        defNew.add(this.extractCPUSummary(line));
        defNew.add(this.extractPrintReferenceGC(line));
        this.publish(defNew);
    }

    public void defNewWithTenuring(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.DefNew;
    }

    public void serialFull(GCLogTrace trace, String line) {
        FullGC collection = new FullGC(this.getClock(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void parNew(GCLogTrace trace, String line) {
        ParNew collection = new ParNew(this.getClock(), trace.gcCause(1), trace.getDuration());
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(13), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 20));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    private void parNewWithTenuring(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
    }

    private void fullGCFLSBefore(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.FullGC;
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    private void parNewFLSBefore(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    private void parNewFLSAfter(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(3);
        this.heapForwardReference = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 10);
    }

    private void parNewFLSBody(GCLogTrace trace, String line) {
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.heapForwardReference = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
    }

    private void parNewConcurrentModeFailureFLSAfter(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == null) {
            this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ConcurrentModeFailure;
        }
        if (this.gcCauseForwardReference == null) {
            this.gcCauseForwardReference = GCCause.LAST_GC_CAUSE;
        }
        this.tenuredForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.heapForwardReference = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        this.metaSpaceForwardReference = this.extractPermOrMetaspaceRecord(line);
    }

    private void parNewFLSTime(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNewPromotionFailed) {
            ParNewPromotionFailed parNew = new ParNewPromotionFailed(this.getClock(), this.gcCauseForwardReference, this.scavengeDurationForwardReference);
            MemoryPoolSummary heap = new MemoryPoolSummary(this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection());
            parNew.add(this.youngMemoryPoolSummaryForwardReference, heap);
            parNew.add(this.scavengeCPUSummaryForwardReference);
            ConcurrentModeFailure cmf = new ConcurrentModeFailure(this.getClock().add(this.scavengeDurationForwardReference), GCCause.CMS_FAILURE, trace.getDuration());
            cmf.add(this.heapForwardReference.minus(this.tenuredForwardReference), this.tenuredForwardReference, this.heapForwardReference);
            cmf.add(this.extractCPUSummary(line));
            cmf.addBinaryTreeDictionary(new BinaryTreeDictionary(this.totalFreeSpaceForwardReference, this.maxChunkSizeForwardReference, this.numberOfBlocksForwardReference, this.averageBlockSizeForwardReference, this.treeHeightForwardReference));
            this.publish(parNew);
            this.publish(cmf);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getPauseTime());
            collection.add(this.youngMemoryPoolSummaryForwardReference, this.heapForwardReference);
            collection.add(this.extractCPUSummary(line));
            collection.addBinaryTreeDictionary(new BinaryTreeDictionary(this.totalFreeSpaceForwardReference, this.maxChunkSizeForwardReference, this.numberOfBlocksForwardReference, this.averageBlockSizeForwardReference, this.treeHeightForwardReference));
            this.publish(collection);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ConcurrentModeFailure) {
            MemoryPoolSummary heap = new MemoryPoolSummary(this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection(), this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection());
            double portionOfPauseToSubtract = this.parNewForwardReference == null ? 0.0 : this.parNewForwardReference.getDuration();
            ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getPauseTime() - portionOfPauseToSubtract);
            concurrentModeFailure.add(this.heapForwardReference.minus(this.tenuredForwardReference), this.tenuredForwardReference, this.heapForwardReference);
            concurrentModeFailure.add(this.extractCPUSummary(line));
            concurrentModeFailure.add(this.metaSpaceForwardReference);
            concurrentModeFailure.addBinaryTreeDictionary(new BinaryTreeDictionary(this.totalFreeSpaceForwardReference, this.maxChunkSizeForwardReference, this.numberOfBlocksForwardReference, this.averageBlockSizeForwardReference, this.treeHeightForwardReference));
            if (this.parNewForwardReference != null) {
                this.parNewForwardReference.add(this.youngMemoryPoolSummaryForwardReference, heap.minus(this.youngMemoryPoolSummaryForwardReference), heap);
                this.publish(this.parNewForwardReference);
            }
            this.publish(concurrentModeFailure);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC) {
            MemoryPoolSummary heap = new MemoryPoolSummary(this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection(), this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection());
            FullGC fullGc = new FullGC(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDuration());
            fullGc.add(heap);
            fullGc.add(this.extractCPUSummary(line));
            this.publish(fullGc);
        } else {
            LOGGER.warning("Unable to parse -> " + trace);
        }
    }

    private void parNewFLSHeader(GCLogTrace trace, String line) {
    }

    private void parNewFLSSeparator(GCLogTrace trace, String line) {
    }

    private void parNewFLSTotalFreeSpace(GCLogTrace trace, String line) {
        this.totalFreeSpaceForwardReference = trace.getLongGroup(1);
    }

    private void parNewFLSMaxChunkSize(GCLogTrace trace, String line) {
        this.maxChunkSizeForwardReference = trace.getLongGroup(1);
    }

    private void parNewFLSNumberOfBlocks(GCLogTrace trace, String line) {
        this.numberOfBlocksForwardReference = trace.getIntegerGroup(1);
    }

    private void parNewFLSAveBlockSize(GCLogTrace trace, String line) {
        this.averageBlockSizeForwardReference = trace.getLongGroup(1);
    }

    private void parNewFLSTreeHeight(GCLogTrace trace, String line) {
        this.treeHeightForwardReference = trace.getIntegerGroup(1);
    }

    private void flsLargeBlockProximity(GCLogTrace trace, String line) {
    }

    private void flsLargeBlock(GCLogTrace trace, String line) {
    }

    private void noop(GCLogTrace trace, String line) {
    }

    public void parNewConcurrentModeEnd(GCLogTrace trace, String line) {
        this.concurrentPhaseEnd(trace, line, 23);
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.scavengeDurationForwardReference = trace.getDoubleGroup(18);
        this.parNewForwardReference = new ParNew(this.scavengeTimeStamp, this.garbageCollectionTypeForwardReference, this.gcCauseForwardReference, this.scavengeDurationForwardReference);
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
    }

    public void parNewCardTable(GCLogTrace trace, String line) {
        LOGGER.warning("Not Yet Implemented -> " + trace);
    }

    public void parNewToConcurrentModeFailure(GCLogTrace trace, String line) {
        ConcurrentModeFailure collection = new ConcurrentModeFailure(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(24), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 31));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void parNewToPsudoConcurrentModeFailure(GCLogTrace trace, String line) {
        ConcurrentModeFailure collection = new ConcurrentModeFailure(this.scavengeTimeStamp, GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void parNewReference(GCLogTrace trace, String line) {
        ParNew gcEvent = new ParNew(trace.getDateTimeStamp(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(51);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(58);
        gcEvent.add(young, heap.minus(young), heap);
        gcEvent.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        gcEvent.add(this.extractCPUSummary(line));
        this.publish(gcEvent);
    }

    public void parNewReferenceSplit(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void gcSplitByTLAB(GCLogTrace trace, String line) {
        if (line.contains("[GC[YG occupancy")) {
            this.remarkTimeStamp = this.getClock();
        }
        this.scavengeTimeStamp = this.getClock();
    }

    public void parNewReferenceSplitByTLAB(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void defNewReference(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.DefNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void parNewPromotionFailed(GCLogTrace trace, String line) {
        ParNewPromotionFailed collection = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDuration());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 19);
        collection.add(young, heap);
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void parNewPromotionFailedDetails(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNewPromotionFailed;
        this.gcCauseForwardReference = GCCause.PROMOTION_FAILED;
        ArrayList<Integer> blocks = new ArrayList<Integer>();
        GCLogTrace block = PARNEW_PROMOTION_FAILURE_SIZE_BLOCK.parse(line);
        do {
            blocks.add(block.getIntegerGroup(1));
        } while (block.hasNext());
        this.promotionFailureSizesForwardReference = new int[blocks.size()];
        for (int index = 0; index < blocks.size(); ++index) {
            this.promotionFailureSizesForwardReference[index] = (Integer)blocks.get(index);
        }
        GCLogTrace memorySummary = BEFORE_AFTER_CONFIGURED_PAUSE_RULE.parse(line);
        this.youngMemoryPoolSummaryForwardReference = memorySummary.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.scavengeDurationForwardReference = memorySummary.getDuration();
    }

    public void parNewPromotionFailedReference(GCLogTrace trace, String line) {
        this.parNewForwardReference = new ParNew(trace.getDateTimeStamp(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(35));
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyWithMemoryPoolSizeSummary(29);
        this.parNewForwardReference.add(this.extractPrintReferenceGC(line));
    }

    public void parNewFloatingReference(GCLogTrace trace, String line) {
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void parNewPromotionFailedTenuring(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNewPromotionFailed;
        this.gcCauseForwardReference = GCCause.PROMOTION_FAILED;
    }

    public void parNewPromotionFailedInConcurrentMarkSweepPhase(GCLogTrace trace, String line) {
        this.concurrentPhaseEnd(trace, line, 15);
        int offset = trace.groupCount() == 23 ? 0 : 2;
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNewPromotionFailed;
        this.gcCauseForwardReference = GCCause.PROMOTION_FAILED;
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(8 - offset);
        this.scavengeDurationForwardReference = trace.getDoubleGroup(14 - offset);
    }

    public void concurrentMarkSweepBailingToForeground(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
        this.scavengeDurationForwardReference = trace.getDoubleGroup(trace.groupCount() - 1);
    }

    public void promotionFailedToFull(GCLogTrace trace, String line) {
        double youngDuration = trace.getDoubleGroup(18);
        ParNewPromotionFailed youngCollection = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, youngDuration);
        MemoryPoolSummary youngGen = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(24);
        MemoryPoolSummary totalHeap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 31);
        youngCollection.add(youngGen, new MemoryPoolSummary(tenured.getOccupancyBeforeCollection(), tenured.getOccupancyBeforeCollection(), tenured.getSizeAfterCollection()), new MemoryPoolSummary(youngGen.getOccupancyBeforeCollection() + tenured.getOccupancyBeforeCollection(), youngGen.getOccupancyAfterCollection() + tenured.getOccupancyBeforeCollection(), youngGen.getSizeAfterCollection() + tenured.getSizeAfterCollection()));
        this.publish(youngCollection);
        DateTimeStamp fullStart = trace.getDateTimeStamp(3);
        double duration = trace.getDuration() - youngDuration;
        FullGC collection = new FullGC(fullStart, GCCause.PROMOTION_FAILED, duration);
        collection.add(totalHeap.minus(tenured), tenured, totalHeap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void parNewPLAB(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void plabEntry(GCLogTrace trace, String line) {
    }

    public void plabSummary(GCLogTrace trace, String line) {
    }

    public void parNewPromotionFailedTimeAbortPreclean(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNewPromotionFailed;
        this.gcCauseForwardReference = GCCause.PROMOTION_FAILED;
        this.scavengeDurationForwardReference = trace.getDoubleGroup(18);
        this.fullGCTimeStamp = this.getClock().add(this.scavengeDurationForwardReference);
        this.scavengeTimeStamp = trace.getDateTimeStamp();
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
    }

    public void parNewPromotionFailedConcurrentPhase(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = trace.getDateTimeStamp();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.scavengeDurationForwardReference = trace.getDoubleGroup(18);
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
        this.concurrentPhaseEnd(trace, line, 19);
    }

    public void corruptedParNewConcurrentPhase(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = trace.getDateTimeStamp();
        this.gcCauseForwardReference = trace.gcCause();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.concurrentPhaseEnd(trace, line, 11);
    }

    public void corruptedParNewBody(GCLogTrace trace, String line) {
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.scavengeTimeStamp, GCCause.PROMOTION_FAILED, trace.getPauseTime() - trace.getDoubleGroup(16));
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 20);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(13);
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary parNewHeap = new MemoryPoolSummary(heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection(), heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection());
        parNewPromotionFailed.add(young, parNewHeap.minus(young), parNewHeap);
        ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.scavengeTimeStamp.add(trace.getDoubleGroup(9) - this.scavengeTimeStamp.getTimeStamp()), GCCause.LAST_GC_CAUSE, trace.getDoubleGroup(16));
        concurrentModeFailure.add(heap.minus(tenured), tenured, heap);
        concurrentModeFailure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        concurrentModeFailure.add(this.extractCPUSummary(line));
        this.publish(parNewPromotionFailed);
        this.publish(concurrentModeFailure);
    }

    public void concurrentPhaseStart(GCLogTrace trace, String line) {
        this.startOfConcurrentPhase = trace.getDateTimeStamp();
        this.inConcurrentPhase = true;
    }

    public void concurrentPhaseEnd(GCLogTrace trace, String line) {
        this.concurrentPhaseEnd(trace, line, 0);
    }

    public void concurrentPhaseEnd(GCLogTrace trace, String line, int offset) {
        try {
            double cpuTime = trace.getDoubleGroup(7 + offset);
            double wallClock = trace.getDoubleGroup(8 + offset);
            switch (trace.getGroup(6 + offset)) {
                case "mark": {
                    this.publish(new ConcurrentMark(this.startOfConcurrentPhase, wallClock, cpuTime, wallClock));
                    break;
                }
                case "preclean": {
                    this.publish(new ConcurrentPreClean(this.startOfConcurrentPhase, wallClock, cpuTime, wallClock));
                    break;
                }
                case "abortable-preclean": {
                    this.publish(new AbortablePreClean(this.startOfConcurrentPhase, wallClock, cpuTime, wallClock, cpuTime > 0.0));
                    break;
                }
                case "sweep": {
                    this.publish(new ConcurrentSweep(this.startOfConcurrentPhase, wallClock, cpuTime, wallClock));
                    break;
                }
                case "reset": {
                    this.publish(new ConcurrentReset(this.startOfConcurrentPhase, wallClock, cpuTime, wallClock));
                    break;
                }
                default: {
                    LOGGER.warning("concurrent phase not recognized end statement -> " + trace);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning("concurrent phase end throws " + e.getMessage() + " for " + trace);
        }
    }

    public void initialMark(GCLogTrace trace, String line) {
        InitialMark initialMark = new InitialMark(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        initialMark.add(trace.getOccupancyWithMemoryPoolSizeSummary(7), this.getTotalOccupancyWithTotalHeapSizeSummary(trace, 11));
        initialMark.add(this.extractCPUSummary(line));
        this.publish(initialMark);
    }

    public void scavengeBeforeRemark(GCLogTrace trace, String line) {
        DateTimeStamp parNewStart = trace.getDateTimeStamp(2);
        ParNew parNew = new ParNew(parNewStart, GCCause.UNKNOWN_GCCAUSE, trace.getDuration());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(20);
        MemoryPoolSummary tenured = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 27);
        parNew.add(young, tenured.minus(young), tenured);
        parNew.add(this.extractCPUSummary(line));
        this.publish(parNew);
    }

    public void scavengeBeforeRemarkTenuring(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = trace.getDateTimeStamp(2);
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
    }

    public void parallelRemarkStringSymbolClause(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, trace.gcCause());
    }

    public void parallelRescan(GCLogTrace trace, String line) {
        CMSRemark collection;
        if (this.remarkTimeStamp != null) {
            collection = new CMSRemark(this.remarkTimeStamp, GCCause.CMS_FINAL_REMARK, trace.getDoubleGroup(trace.groupCount()));
            this.remarkTimeStamp = null;
        } else {
            collection = new CMSRemark(this.getClock(), GCCause.CMS_FINAL_REMARK, trace.getDuration());
        }
        MemoryPoolSummary tenured = trace.getOccupancyWithMemoryPoolSizeSummary(19);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(trace, 23);
        collection.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(collection, line);
        collection.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
        if (this.parNewForwardReference != null) {
            this.publish(this.parNewForwardReference);
            this.parNewForwardReference = null;
        }
    }

    public void rescanWeakClassSymbolString(GCLogTrace trace, String line) {
        CMSRemark remark = new CMSRemark(this.getClock(), GCCause.CMS_FINAL_REMARK, trace.getDuration());
        MemoryPoolSummary tenured = new MemoryPoolSummary(trace.toKBytes(20), trace.toKBytes(22), trace.toKBytes(20), trace.toKBytes(22));
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(24), trace.toKBytes(26), trace.toKBytes(24), trace.toKBytes(26));
        remark.add(this.youngMemoryPoolSummaryForwardReference, tenured, heap);
        this.recordRescanStepTimes(remark, line);
        remark.add(this.extractCPUSummary(line));
        this.publish(remark);
    }

    public void recordRemark(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, trace.gcCause());
    }

    public void remarkParNewPromotionFailed(GCLogTrace trace, String line) {
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(11);
        MemoryPoolSummary tenured = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 18);
        parNewPromotionFailed.add(young, tenured.minus(young), tenured);
        parNewPromotionFailed.add(this.extractCPUSummary(line));
        this.publish(parNewPromotionFailed);
    }

    public void tenuringDetails(GCLogTrace trace, String line) {
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDuration());
            collection.add(young, heap);
            collection.add(this.referenceGCForwardReference);
            collection.add(this.extractCPUSummary(line));
            this.publish(collection);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.DefNew) {
            DefNew collection = new DefNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(14));
            collection.add(young, heap);
            collection.add(this.referenceGCForwardReference);
            collection.add(this.extractCPUSummary(line));
            this.publish(collection);
        }
    }

    public void concurrentModeFailureDetails(GCLogTrace trace, String line) {
        FullGC failure;
        MemoryPoolSummary tenuredPoolSummary = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heapSummary = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, this.scavengeDurationForwardReference);
            collection.add(this.youngMemoryPoolSummaryForwardReference, new MemoryPoolSummary(tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeBeforeCollection(), tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeAfterCollection()), new MemoryPoolSummary(heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeBeforeCollection(), heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeAfterCollection()));
            collection.add(this.extractCPUSummary(line));
            this.publish(collection, false);
            failure = new ConcurrentModeFailure(this.getClock(), this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            this.youngMemoryPoolSummaryForwardReference = heapSummary.minus(tenuredPoolSummary);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.DefNew) {
            DefNew collection = new DefNew(this.scavengeTimeStamp, this.gcCauseForwardReference, this.scavengeDurationForwardReference);
            collection.add(this.youngMemoryPoolSummaryForwardReference, new MemoryPoolSummary(tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeBeforeCollection(), tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeAfterCollection()), new MemoryPoolSummary(heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeBeforeCollection(), heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeAfterCollection()));
            collection.add(this.extractCPUSummary(line));
            this.publish(collection, false);
            failure = new ConcurrentModeFailure(this.getClock(), this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            this.youngMemoryPoolSummaryForwardReference = heapSummary.minus(tenuredPoolSummary);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNewPromotionFailed) {
            ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, this.gcCauseForwardReference, this.scavengeDurationForwardReference);
            collection.add(this.youngMemoryPoolSummaryForwardReference, new MemoryPoolSummary(tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeBeforeCollection(), tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeAfterCollection()), new MemoryPoolSummary(heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeBeforeCollection(), heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeAfterCollection()));
            collection.add(this.extractCPUSummary(line));
            this.publish(collection, false);
            failure = new ConcurrentModeFailure(this.getClock(), this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            this.youngMemoryPoolSummaryForwardReference = heapSummary.minus(tenuredPoolSummary);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ConcurrentModeFailure || this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC) {
            failure = line.contains("interrupted") ? new ConcurrentModeInterrupted(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount())) : new ConcurrentModeFailure(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            if (this.youngMemoryPoolSummaryForwardReference == null) {
                this.youngMemoryPoolSummaryForwardReference = heapSummary.minus(tenuredPoolSummary);
            }
        } else {
            LOGGER.warning("Unable to parse -> " + trace);
            return;
        }
        failure.add(this.youngMemoryPoolSummaryForwardReference, tenuredPoolSummary, heapSummary);
        failure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        failure.add(this.extractCPUSummary(line));
        this.publish(failure);
    }

    public void parNewDetailsConcurrentModeFailure(GCLogTrace trace, String line) {
        ParNew parNew = new ParNew(this.scavengeTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(7));
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(1) + trace.toKBytes(13), trace.toKBytes(24), trace.toKBytes(20), trace.toKBytes(24));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        parNew.add(young, heap);
        parNew.add(this.extractCPUSummary(line));
        this.publish(parNew, false);
        if (this.inConcurrentPhase) {
            LOGGER.warning("concurrent phase not closed");
        }
        ConcurrentModeFailure collection = new ConcurrentModeFailure(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDuration());
        collection.add(new MemoryPoolSummary(trace.toKBytes(3), trace.toKBytes(5), 0L, trace.toKBytes(5)), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(13), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(20));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void parNewDetailsPromotionFailedWithConcurrentMarkSweepPhase(GCLogTrace trace, String line) {
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.scavengeDurationForwardReference = trace.getDoubleGroup(7);
        GCLogTrace concurrentPhase = CONCURRENT_PHASE_END_BLOCK.parse(line);
        if (concurrentPhase != null) {
            this.endOfConcurrentPhase(concurrentPhase, line);
        }
    }

    public void parNewDetailsWithConcurrentModeFailure(GCLogTrace trace, String line) {
        ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(7));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(20), trace.toKBytes(24), trace.toKBytes(20), trace.toKBytes(24));
        MemoryPoolSummary tenured = heap.minus(young);
        collection.add(young, tenured, heap);
        collection.add(this.extractCPUSummary(line));
        this.publish(collection, false);
        ConcurrentModeFailure fullCollection = new ConcurrentModeFailure(this.getClock(), this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(13);
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 20);
        young = heap.minus(tenured);
        fullCollection.add(young, tenured, heap);
        fullCollection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        fullCollection.add(this.extractCPUSummary(line));
        this.publish(fullCollection);
    }

    public void concurrentModeFailureReference(GCLogTrace trace, String line) {
        FullGC collection;
        GCLogTrace memoryPoolSummary = POOL_OCCUPANCY_HEAP_OCCUPANCY_BLOCK.parse(line);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(memoryPoolSummary, 8);
        MemoryPoolSummary tenured = memoryPoolSummary.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        if (this.fullGCTimeStamp == null) {
            this.fullGCTimeStamp = this.getClock().add(this.parNewForwardReference.getDuration());
            MemoryPoolSummary parNewHeap = new MemoryPoolSummary(heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection(), heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection());
            MemoryPoolSummary parNewTenured = parNewHeap.minus(this.youngMemoryPoolSummaryForwardReference);
            this.parNewForwardReference.add(this.youngMemoryPoolSummaryForwardReference, parNewTenured, parNewHeap);
            this.publish(this.parNewForwardReference, false);
            collection = new ConcurrentModeFailure(this.fullGCTimeStamp, GCCause.CMS_FAILURE, trace.getDoubleGroup(trace.groupCount()));
        } else {
            collection = new FullGC(this.fullGCTimeStamp, GCCause.CMS_FAILURE, trace.getDoubleGroup(trace.groupCount()));
        }
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractPrintReferenceGC(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void iCMSConcurrentModeFailureDuringParNewDefNewTenuringDetails(GCLogTrace trace, String line) {
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        int dutyCycle = trace.getIntegerGroup(14);
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(dutyCycle);
            collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
            collection.add(this.extractCPUSummary(line));
            this.publish(collection);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC) {
            SystemGC collection = new SystemGC(this.fullGCTimeStamp, GCCause.JAVA_LANG_SYSTEM, trace.getDoubleGroup(trace.groupCount()));
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(dutyCycle);
            collection.add(this.extractCPUSummary(line));
            this.publish(collection);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNewPromotionFailed) {
            ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(dutyCycle);
            collection.add(this.extractCPUSummary(line));
            this.publish(collection);
        } else {
            LOGGER.log(Level.WARNING, "@" + this.scavengeTimeStamp + ". ParNew details not preceded by a ParNew: " + this.garbageCollectionTypeForwardReference);
        }
    }

    public void iCMSConcurrentModeFailure(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC || this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ConcurrentModeFailure) {
            ConcurrentModeFailure failure = new ConcurrentModeFailure(this.fullGCTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getDuration());
            failure.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8));
            failure.recordDutyCycle(trace.getIntegerGroup(21));
            failure.add(this.extractCPUSummary(line));
            this.publish(failure);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew || this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNewPromotionFailed) {
            ParNew collection = this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew ? new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount())) : new ParNewPromotionFailed(this.scavengeTimeStamp, trace.getDoubleGroup(trace.groupCount()) - trace.getDoubleGroup(7));
            collection.add(this.youngMemoryPoolSummaryForwardReference, new MemoryPoolSummary(trace.getLongGroup(8), trace.getLongGroup(12), trace.getLongGroup(8), trace.getLongGroup(12)));
            collection.add(this.extractCPUSummary(line));
            this.publish(collection, false);
            if (this.fullGCTimeStamp == null) {
                this.fullGCTimeStamp = this.scavengeTimeStamp.add(trace.getDoubleGroup(7));
            }
            ConcurrentModeFailure failure = new ConcurrentModeFailure(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(7));
            MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
            MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            failure.add(heap.minus(tenured), tenured, heap);
            failure.recordDutyCycle(trace.getIntegerGroup(21));
            failure.add(this.extractCPUSummary(line));
            this.publish(failure);
        } else {
            LOGGER.warning("Unable to parse -> " + trace);
        }
    }

    public void iCMSConcurrentModeFailureDuringParNewDefNewDetails(GCLogTrace trace, String line) {
        GenerationalGCPauseEvent collection = new ParNewPromotionFailed(this.scavengeTimeStamp, trace.getDoubleGroup(7));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(20), trace.toKBytes(24), trace.toKBytes(20), trace.toKBytes(24));
        collection.add(young, heap.minus(young), heap);
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
        collection = new ConcurrentModeFailure(this.getClock(), GCCause.CMS_FAILURE, trace.getDuration());
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(13);
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 20);
        collection.add(heap.minus(tenured), tenured, heap);
        ((FullGC)collection).recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void fullGCInterruptsConcurrentPhase(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.FullGC;
        this.gcCauseForwardReference = trace.gcCause();
        this.endOfConcurrentPhase(trace, trace.getDateTimeStamp(3), 11);
    }

    public void fullGCReferenceConcurrentModeFailure(GCLogTrace trace, String line) {
        ConcurrentModeFailure collection = new ConcurrentModeFailure(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        GCLogTrace memorySummary = MEMORY_SUMMARY_RULE.parse(line);
        MemoryPoolSummary tenured = memorySummary.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(memorySummary.next(), 1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(memorySummary.next(), 1);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void fullParNewStart(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.scavengeTimeStamp = trace.getDateTimeStamp(2);
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.FullGC;
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void iCMSParNew(GCLogTrace trace, String line) {
        int offset = 12;
        ParNew parNew = new ParNew(this.getClock(), trace.gcCause(), trace.getDuration());
        parNew.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(offset), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, offset + 7));
        parNew.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        parNew.add(this.extractCPUSummary(line));
        this.publish(parNew);
    }

    public void iCMSParNewPromotionFailureRecord(GCLogTrace trace, String line) {
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(19));
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(32), trace.toKBytes(36), trace.toKBytes(32), trace.toKBytes(36));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(13);
        MemoryPoolSummary tenured = heap.minus(young);
        parNewPromotionFailed.add(young, tenured, heap);
        parNewPromotionFailed.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 2));
        this.publish(parNewPromotionFailed);
        DateTimeStamp fullGCStart = trace.getDateTimeStamp(3);
        fullGCStart = this.getClock().add(fullGCStart.getTimeStamp() - this.getClock().getTimeStamp());
        FullGC fullGC = new FullGC(fullGCStart, GCCause.PROMOTION_FAILED, trace.getDoubleGroup(31));
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 32);
        tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(25);
        young = new MemoryPoolSummary(0L, trace.toKBytes(17), 0L, trace.toKBytes(17));
        fullGC.add(young, tenured, heap);
        fullGC.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        fullGC.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 2));
        this.publish(fullGC);
    }

    public void iCMSParNewPromotionFailure(GCLogTrace trace, String line) {
        double parnewDuration = trace.getDoubleGroup(18);
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, parnewDuration);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(31);
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
        MemoryPoolSummary tenured = heap.minus(young);
        parNewPromotionFailed.add(young, tenured, new MemoryPoolSummary(heap.getOccupancyBeforeCollection(), heap.getSizeBeforeCollection(), heap.getOccupancyBeforeCollection(), heap.getSizeBeforeCollection()));
        parNewPromotionFailed.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        this.publish(parNewPromotionFailed);
        DateTimeStamp fullGCStart = trace.getDateTimeStamp(3);
        ConcurrentModeFailure fullGC = new ConcurrentModeFailure(fullGCStart, GCCause.PROMOTION_FAILED, trace.getDuration() - parnewDuration);
        tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(24);
        young = new MemoryPoolSummary(young.getOccupancyBeforeCollection(), young.getSizeBeforeCollection(), 0L, young.getSizeAfterCollection());
        fullGC.add(young, tenured, heap);
        fullGC.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        fullGC.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        this.publish(fullGC);
    }

    public void fullGCiCMS(GCLogTrace trace, String line) {
        FullGC collection = trace.gcCause() == GCCause.JAVA_LANG_SYSTEM ? new SystemGC(this.getClock(), trace.gcCause(), trace.getDuration()) : new FullGC(this.getClock(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(8);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 15);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void iCMSParNewDefNewTenuringDetails(GCLogTrace trace, String line) {
        if (GarbageCollectionTypes.ParNew == this.garbageCollectionTypeForwardReference) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDuration());
            collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8));
            collection.recordDutyCycle(trace.getIntegerGroup(14));
            collection.add(this.extractCPUSummary(line));
            this.publish(collection);
        } else if (GarbageCollectionTypes.ParNewPromotionFailed == this.garbageCollectionTypeForwardReference) {
            ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDuration());
            MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
            this.publish(collection);
        } else if (GarbageCollectionTypes.FullGC == this.garbageCollectionTypeForwardReference) {
            FullGC collection = new FullGC(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDuration());
            MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
            this.publish(collection);
        } else {
            LOGGER.warning("Not reported: " + line);
        }
    }

    public void iCMSPromotionFailed(GCLogTrace trace, String line) {
        ParNewPromotionFailed collection = new ParNewPromotionFailed(this.getClock(), trace.getDuration());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(8);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 15);
        collection.add(young, heap.minus(young), heap);
        collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        this.publish(collection);
    }

    private void iCMSFullGC(GCLogTrace trace, String line) {
        FullGC collection;
        GCCause cause = trace.gcCause();
        if (cause == GCCause.JAVA_LANG_SYSTEM) {
            collection = new SystemGC(this.getClock(), trace.getDuration());
        } else if (cause == GCCause.UNKNOWN_GCCAUSE || cause == GCCause.GCCAUSE_NOT_SET) {
            collection = new FullGC(this.getClock(), cause, trace.getDuration());
        } else {
            LOGGER.warning("Unable to parse -> " + trace);
            return;
        }
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 19);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        this.publish(collection);
    }

    public void iCMSMislabeledFull(GCLogTrace trace, String line) {
        double parNewDuration = trace.getDoubleGroup(18);
        ParNew parNew = new ParNew(trace.getDateTimeStamp(2), trace.gcCause(), parNewDuration);
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(24);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 31);
        parNew.add(young, new MemoryPoolSummary(tenured.getOccupancyBeforeCollection(), tenured.getSizeAfterCollection(), tenured.getOccupancyBeforeCollection(), tenured.getSizeAfterCollection()), new MemoryPoolSummary(heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection(), heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection()));
        this.publish(parNew);
        FullGC full = new FullGC(trace.getDateTimeStamp(3), trace.gcCause(), trace.getDuration());
        full.add(heap.minus(tenured), tenured, heap);
        full.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        full.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        full.add(this.extractCPUSummary(line));
        this.publish(full);
    }

    public void iCMSFullAfterConcurrentModeFailure(GCLogTrace trace, String line) {
        ConcurrentModeFailure failure = new ConcurrentModeFailure(this.getClock(), GCCause.UNKNOWN_GCCAUSE, trace.getDuration());
        failure.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 19));
        failure.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        failure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        failure.add(this.extractCPUSummary(line));
        this.publish(failure);
    }

    public void iCMSConcurrentModeInterrupted(GCLogTrace trace, String line) {
        if (this.fullGCTimeStamp == null) {
            this.fullGCTimeStamp = this.getClock();
            this.logMissedFirstRecordForEvent(line);
        }
        ConcurrentModeInterrupted collection = new ConcurrentModeInterrupted(this.fullGCTimeStamp, this.garbageCollectionTypeForwardReference, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void psFullGCMeta(GCLogTrace trace, String line) {
        GCCause cause = trace.gcCause();
        FullGC collection = cause == GCCause.JAVA_LANG_SYSTEM || cause == GCCause.HEAP_DUMP ? new SystemGC(this.getClock(), cause, trace.getDuration()) : new PSFullGC(this.getClock(), cause, trace.getDuration());
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(8), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(14), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 20));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void psFullGCV2Meta(GCLogTrace trace, String line) {
        SystemGC collection = new SystemGC(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void parNewConcurrentModeFailurePerm(GCLogTrace trace, String line) {
        double concurrentModeFailurePause = trace.getDoubleGroup(26);
        double parNewPause = trace.getDoubleGroup(18);
        double startTimeGap = trace.getDoubleGroup(13) - this.getClock().getTimeStamp();
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), trace.gcCause(), parNewPause);
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(27), trace.toKBytes(31), trace.toKBytes(27), trace.toKBytes(31));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(12);
        parNewPromotionFailed.add(young, heap.minus(young), heap);
        this.publish(parNewPromotionFailed);
        ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.getClock().add(startTimeGap), GCCause.PROMOTION_FAILED, concurrentModeFailurePause);
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 27);
        young = new MemoryPoolSummary(trace.toKBytes(14), trace.toKBytes(16), 0L, trace.toKBytes(16));
        concurrentModeFailure.add(young, heap.minus(young), heap);
        concurrentModeFailure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        concurrentModeFailure.add(this.extractCPUSummary(line));
        this.publish(concurrentModeFailure);
    }

    public void fullSplitByConcurrentPhase(GCLogTrace trace, String line) {
    }

    public void concurrentModeFailureSplitByLargeBlock(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC) {
            this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ConcurrentModeFailure;
        }
    }

    public void fullParNewConcurrentModeFailurePerm(GCLogTrace trace, String line) {
        this.extractPermOrMetaspaceRecord(line);
    }

    public void fullParNewConcurrentModeFailureMeta(GCLogTrace trace, String line) {
        this.extractPermOrMetaspaceRecord(line);
    }

    public void psFullGCV2Perm(GCLogTrace trace, String line) {
        SystemGC collection = new SystemGC(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void psFullGCPerm(GCLogTrace trace, String line) {
        GCCause cause = trace.gcCause();
        FullGC collection = cause == GCCause.JAVA_LANG_SYSTEM || cause == GCCause.HEAP_DUMP ? new SystemGC(this.getClock(), cause, trace.getDuration()) : new PSFullGC(this.getClock(), cause, trace.getDuration());
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(8), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(14), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 20));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void cmsFullPermOrMeta(GCLogTrace trace, String line) {
        try {
            GCCause cause = trace.gcCause();
            FullGC collection = cause == GCCause.JAVA_LANG_SYSTEM || cause == GCCause.HEAP_DUMP ? new SystemGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount())) : new FullGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount()));
            GCLogTrace memorySummary = MEMORY_SUMMARY_RULE.parse(line);
            MemoryPoolSummary tenuredPoolSummary = memorySummary.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heapSummary = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(memorySummary.next(), 1);
            collection.add(heapSummary.minus(tenuredPoolSummary), tenuredPoolSummary, heapSummary);
            collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
            collection.add(this.extractPrintReferenceGC(line));
            collection.add(this.extractCPUSummary(line));
            this.publish(collection);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, this.getClock().getTimeStamp() + " : parsing record resulted in an exception", t);
        }
    }

    public void parNewNoDetails(GCLogTrace trace, String line) {
        ParNew parNew = new ParNew(this.getClock(), GarbageCollectionTypes.Young, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
        parNew.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 3));
        parNew.add(this.extractCPUSummary(line));
        this.publish(parNew);
    }

    public void youngNoDetails(GCLogTrace trace, String line) {
        YoungGC youngGC = new YoungGC(this.getClock(), GarbageCollectionTypes.Young, GCCause.UNKNOWN_GCCAUSE, trace.getDuration());
        youngGC.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 6));
        youngGC.add(this.extractCPUSummary(line));
        this.publish(youngGC);
    }

    public void cmsNoDetails(GCLogTrace trace, String line) {
        if (this.expectRemark) {
            this.expectRemark = false;
            CMSRemark remark = new CMSRemark(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
            remark.add(this.getTotalOccupancyWithTotalHeapSizeSummary(trace, 6));
            remark.add(this.extractCPUSummary(line));
            this.publish(remark);
        } else {
            this.expectRemark = true;
            InitialMark initialMark = new InitialMark(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
            initialMark.add(this.getTotalOccupancyWithTotalHeapSizeSummary(trace, 6));
            initialMark.add(this.extractCPUSummary(line));
            this.publish(initialMark);
        }
    }

    public void fullNoGCDetails(GCLogTrace trace, String line) {
        this.expectRemark = false;
        FullGC fullGC = new FullGC(this.getClock(), GCCause.UNKNOWN_GCCAUSE, trace.getDuration());
        fullGC.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 6));
        this.publish(fullGC);
    }

    public void parNewStart(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        if (this.gcCauseForwardReference == null) {
            this.gcCauseForwardReference = GCCause.UNKNOWN_GCCAUSE;
        }
        this.scavengeTimeStamp = this.getClock();
    }

    public void gcStart(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.Young;
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void youngSplitNoDetails(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew parNew = new ParNew(this.scavengeTimeStamp, GarbageCollectionTypes.ParNew, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
            parNew.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 1));
            parNew.add(this.extractCPUSummary(line));
            this.publish(parNew);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.Young) {
            YoungGC youngGC = new YoungGC(this.scavengeTimeStamp, GarbageCollectionTypes.Young, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
            youngGC.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 1));
            youngGC.add(this.extractCPUSummary(line));
            this.publish(youngGC);
        }
    }

    public void cmfSimple(GCLogTrace trace, String line) {
        ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        concurrentModeFailure.add(this.extractCPUSummary(line));
        this.publish(concurrentModeFailure);
    }

    public void psYoungGen(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(8), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 14));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void psFull(GCLogTrace trace, String line) {
        GCCause cause = trace.gcCause();
        FullGC collection = cause == GCCause.JAVA_LANG_SYSTEM || cause == GCCause.HEAP_DUMP || cause == GCCause.HEAP_INSPECTION ? new SystemGC(trace.getDateTimeStamp(), cause, trace.getDuration()) : new FullGC(trace.getDateTimeStamp(), cause, trace.getDuration());
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(4));
        this.publish(collection);
    }

    public void psYoungNoDetails(GCLogTrace trace, String line) {
        GCCause cause = trace.gcCause();
        if (GCCause.JAVA_LANG_SYSTEM == cause) {
            SystemGC collection = new SystemGC(trace.getDateTimeStamp(), GCCause.JAVA_LANG_SYSTEM, trace.getDuration());
            collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(4));
            this.publish(collection);
        } else {
            PSYoungGen collection = new PSYoungGen(trace.getDateTimeStamp(), cause, trace.getDuration());
            collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(4));
            this.publish(collection);
        }
    }

    public void psYoungGenReferenceProcessingSplit(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void psYoungGenReferenceProcessing(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.getClock(), trace.gcCause(), trace.getDuration());
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(28), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 34));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void psTenuringStart(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void psFullSPlit(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.garbageCollectionTypeForwardReference = this.gcCauseForwardReference == GCCause.JAVA_LANG_SYSTEM ? GarbageCollectionTypes.SystemGC : GarbageCollectionTypes.PSFull;
    }

    public void psFullReferenceSplit(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.garbageCollectionTypeForwardReference = this.gcCauseForwardReference == GCCause.JAVA_LANG_SYSTEM ? GarbageCollectionTypes.SystemGC : (this.gcCauseForwardReference == GCCause.HEAP_DUMP ? GarbageCollectionTypes.SystemGC : GarbageCollectionTypes.PSFull);
    }

    public void psFullReference(GCLogTrace trace, String line) {
        FullGC collection = trace.gcCause() == GCCause.JAVA_LANG_SYSTEM ? new SystemGC(trace.getDateTimeStamp(), trace.gcCause(), trace.getPauseTime()) : new PSFullGC(trace.getDateTimeStamp(), trace.gcCause(), trace.getPauseTime());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(29);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(35);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(41);
        collection.add(young, tenured, heap);
        collection.add(this.extractPrintReferenceGC(line));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void psFullReferenceJDK8(GCLogTrace trace, String line) {
        FullGC fullGC = new FullGC(this.getClock(), GarbageCollectionTypes.FullGC, trace.gcCause(), trace.getDuration());
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(30);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(37);
        fullGC.add(heap.minus(tenured), tenured, heap);
        fullGC.add(this.extractPrintReferenceGC(line));
        fullGC.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        fullGC.add(this.extractCPUSummary(line));
        this.publish(fullGC);
    }

    public void serialFullReference(GCLogTrace trace, String line) {
        FullGC collection = trace.gcCause().equals((Object)GCCause.JAVA_LANG_SYSTEM) ? new SystemGC(trace.getDateTimeStamp(), trace.gcCause(), trace.getDuration()) : new FullGC(trace.getDateTimeStamp(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(30);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(37);
        MemoryPoolSummary young = new MemoryPoolSummary(heap.getOccupancyBeforeCollection() - tenured.getOccupancyBeforeCollection(), 0L, heap.getSizeAfterCollection() - tenured.getSizeAfterCollection());
        collection.add(young, tenured, heap);
        collection.add(this.extractPrintReferenceGC(line));
        collection.add(this.extractCPUSummary(line));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        this.publish(collection);
    }

    public void psFullErgonomicsPhases(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.garbageCollectionTypeForwardReference = this.gcCauseForwardReference != GCCause.JAVA_LANG_SYSTEM ? GarbageCollectionTypes.FullGC : GarbageCollectionTypes.SystemGC;
    }

    public void psFullReferencePhase(GCLogTrace trace, String line) {
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void psDetailsWithTenuring(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDuration());
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(2), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8));
        if (this.referenceGCForwardReference != null) {
            collection.add(this.referenceGCForwardReference);
        }
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void psFailure(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(8), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 14));
    }

    public void psYoungAdaptiveSizePolicy(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.PSYoungGen;
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        if (line.contains("SoftReference")) {
            this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
        }
    }

    public void psFullAdaptiveSizePolicy(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.PSFull;
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void psYoungDetailsFloating(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 7));
        this.publish(collection);
    }

    public void psFullAdaptiveSize(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void psFullBodyFloating(GCLogTrace trace, String line) {
        FullGC collection = this.gcCauseForwardReference == GCCause.JAVA_LANG_SYSTEM || this.gcCauseForwardReference == GCCause.HEAP_DUMP ? new SystemGC(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount())) : new PSFullGC(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getPauseTime());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(2);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(9);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 15);
        collection.add(young, tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        if (this.referenceGCForwardReference != null) {
            collection.add(this.referenceGCForwardReference);
        }
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    public void psFullReferenceAdaptiveSize(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void psPromotionFailed(GCLogTrace trace, String line) {
        if (GarbageCollectionTypes.DefNew == this.garbageCollectionTypeForwardReference) {
            DefNew youngGC = new DefNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(7));
            MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heap = new MemoryPoolSummary(young.getOccupancyBeforeCollection() + trace.toKBytes(9), trace.toKBytes(20), trace.toKBytes(16), trace.toKBytes(20));
            youngGC.add(young, heap);
            double cpuBreakDownRatio = trace.getDoubleGroup(7) / trace.getDoubleGroup(trace.groupCount());
            CPUSummary cpuSummary = this.extractCPUSummary(line);
            if (cpuSummary != null) {
                double user = cpuSummary.getUser();
                double kernel = cpuSummary.getKernel();
                double real = cpuSummary.getWallClock();
                youngGC.add(new CPUSummary(user * cpuBreakDownRatio, kernel * cpuBreakDownRatio, real * cpuBreakDownRatio));
                cpuBreakDownRatio = 1.0 - cpuBreakDownRatio;
                cpuSummary = new CPUSummary(user * cpuBreakDownRatio, kernel * cpuBreakDownRatio, real * cpuBreakDownRatio);
            }
            this.publish(youngGC, false);
            DateTimeStamp timeOfFullCollection = new DateTimeStamp(trace.getDoubleGroup(8));
            FullGC fullGC = new FullGC(timeOfFullCollection, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()) - trace.getDoubleGroup(7));
            young = new MemoryPoolSummary(young.getOccupancyAfterCollection(), young.getSizeAfterCollection(), 0L, young.getSizeAfterCollection());
            fullGC.add(young, trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(16));
            fullGC.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
            fullGC.add(cpuSummary);
            this.publish(fullGC);
        } else {
            LOGGER.warning("Unable to parse -> " + trace);
        }
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.DefNew;
    }

    public void rescanSplitUnloadingString(GCLogTrace trace, String line) {
        LOGGER.warning("Not Yet Implemented -> " + trace);
    }

    public void parNewConcurrentPhaseCards(GCLogTrace trace, String line) {
        LOGGER.warning("Not Yet Implemented -> " + trace);
    }

    public void concurrentPhaseYields(GCLogTrace trace, String line) {
        this.endOfConcurrentPhase(trace, line);
    }

    private void precleanTimedoutWithCards(GCLogTrace trace, String line) {
        this.abortPrecleanDueToTime = true;
        GCLogTrace concurrentPhase = new GCParseRule("X", "((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )\\[CMS-concurrent-(.+): (-?\\d+(?:\\.|,)\\d+)/(-?\\d+(?:\\.|,)\\d+) secs\\]").parse(line);
        this.endOfConcurrentPhase(concurrentPhase, concurrentPhase.getDateTimeStamp(), 0);
    }

    private void shouldCollectConcurrent(GCLogTrace trace, String line) {
        LOGGER.warning("Not Yet Implemented -> " + trace);
    }

    public void parNewShouldConcurrentCollect(GCLogTrace trace, String line) {
        LOGGER.warning("Not yet Implemented -> " + trace);
    }

    private void psYoungAdaptivePolicySizeStart(GCLogTrace trace, String line) {
        LOGGER.warning("Not yet Implemented -> " + trace);
    }

    private void psYoungAdaptivePolicySizeBody(GCLogTrace trace, String line) {
        LOGGER.warning("Not yet Implemented -> " + trace);
    }

    private void adaptivePolicySizeBody(GCLogTrace trace, String line) {
        LOGGER.warning("Not yet Implemented -> " + trace);
    }

    public void remarkSplitByDebug(GCLogTrace trace, String line) {
        long youngOccupancy = trace.getLongGroup(7);
        long youngConfiguredSize = trace.getLongGroup(8);
        this.youngMemoryPoolSummaryForwardReference = new MemoryPoolSummary(youngOccupancy, youngConfiguredSize, youngOccupancy, youngConfiguredSize);
    }

    public void scavengeBeforeRemarkReference(GCLogTrace trace, String line) {
        this.parNewForwardReference = new ParNew(trace.getDateTimeStamp(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount() - 3));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(59);
        MemoryPoolSummary tenured = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 66);
        this.parNewForwardReference.add(young, tenured.minus(young), tenured);
        this.parNewForwardReference.add(this.extractPrintReferenceGC(line));
        this.parNewForwardReference.add(this.extractCPUSummary(line));
        this.publish(this.parNewForwardReference, false);
    }

    public void preCleanReferenceParNewReference(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause(16);
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void scavengeBeforeRemarkReferenceSplit(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.remarkTimeStamp = this.getClock();
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = GCCause.CMS_FINAL_REMARK;
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void scavengeBeforeRemarkPrintHeapAtGC(GCLogTrace trace, String line) {
        this.remarkTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void splitRemarkReference(GCLogTrace trace, String line) {
        CMSRemark remark = new CMSRemark(this.getClock(), this.gcCauseForwardReference, trace.getPauseTime());
        GCLogTrace remarkClause = REMARK_CLAUSE.parse(line);
        MemoryPoolSummary tenured = this.getTotalOccupancyWithTotalHeapSizeSummary(remarkClause, 1);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(remarkClause, 5);
        remark.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(remark, line);
        remark.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        remark.add(this.extractCPUSummary(line));
        this.publish(remark);
        this.remarkTimeStamp = null;
    }

    public void splitRemarkReferenceWithWeakReferenceSplitBug(GCLogTrace trace, String line) {
        GCLogTrace remarkTrace = REMARK_CLAUSE.parse(line);
        Pattern durationGroupPattern = Pattern.compile(".* (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)");
        Matcher matcher = durationGroupPattern.matcher(line);
        double duration = 0.0;
        if (matcher.find()) {
            duration = Double.parseDouble(matcher.group(matcher.groupCount()));
        }
        CMSRemark collection = new CMSRemark(this.getClock(), GCCause.CMS_FINAL_REMARK, duration);
        MemoryPoolSummary tenured = this.getTotalOccupancyWithTotalHeapSizeSummary(remarkTrace, 1);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(remarkTrace, 5);
        collection.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(collection, line);
        collection.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        GCLogTrace weakReferenceFragment = this.weakReferenceFragmentRule.parse(line);
        if (weakReferenceFragment != null) {
            collection.getReferenceGCSummary().addWeakReferences(trace.getDateTimeStamp(2), 0, weakReferenceFragment.getPauseTime());
        }
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
        this.remarkTimeStamp = null;
    }

    public void adaptiveSizePolicyStop(GCLogTrace trace, String line) {
    }

    private void recordRemark(GCLogTrace trace, String line, GCCause gcCause) {
        CMSRemark collection = gcCause == GCCause.UNKNOWN_GCCAUSE ? new CMSRemark(this.getClock(), trace.getDuration()) : new CMSRemark(this.getClock(), gcCause, trace.getDuration());
        GCLogTrace remarkBlock = this.cmsRemarkBlockRule.parse(line);
        if (remarkBlock == null) {
            LOGGER.warning("Internal error, unable to parse CMS information from " + line);
        } else {
            MemoryPoolSummary tenured = remarkBlock.getOccupancyWithMemoryPoolSizeSummary();
            MemoryPoolSummary heap = remarkBlock.getOccupancyWithMemoryPoolSizeSummary();
            collection.add(heap.minus(tenured), tenured, heap);
            this.recordRescanStepTimes(collection, line);
            collection.add(this.extractCPUSummary(line));
            this.publish(collection);
        }
    }

    private void recordRemarkWithReferenceProcessing(GCLogTrace trace, String line) {
        GCCause gcCause = trace.gcCause();
        if (gcCause == GCCause.UNKNOWN_GCCAUSE) {
            gcCause = GCCause.CMS_FINAL_REMARK;
        }
        CMSRemark collection = new CMSRemark(this.getClock(), gcCause, trace.getDoubleGroup(trace.groupCount()));
        GCLogTrace memorySummary = OCCUPANCY_CONFIGURED_RULE.parse(line);
        MemoryPoolSummary tenured = memorySummary.getOccupancyWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(memorySummary.next(), 1);
        collection.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(collection, line);
        collection.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        collection.add(this.extractCPUSummary(line));
        this.publish(collection);
    }

    private void log(String line) {
        if (line.startsWith("Metaspace       used")) {
            return;
        }
        if (line.startsWith("class space    used")) {
            return;
        }
        if (line.startsWith("par new generation   total")) {
            return;
        }
        if (line.startsWith("concurrent-mark-sweep perm gen total")) {
            return;
        }
        if (line.startsWith("(cardTable: ")) {
            return;
        }
        if (line.startsWith("def new generation   total")) {
            return;
        }
        if (line.contains("CMSCMS: Large block")) {
            return;
        }
        LOGGER.log(Level.WARNING, "Missed: {0}", line);
    }

    private void abortPrecleanDueToTime(GCLogTrace trace, String line) {
        try {
            double cpuTime = trace.getDoubleGroup(7);
            double wallClock = trace.getDoubleGroup(8);
            this.publish(new AbortablePreClean(this.startOfConcurrentPhase, wallClock, cpuTime, wallClock, true));
            this.abortPrecleanDueToTime = false;
        }
        catch (Exception e) {
            LOGGER.warning("concurrent phase end choked on " + trace);
        }
    }

    private void abortPrecleanWithCards(GCLogTrace trace, String line) {
        try {
            double cpuTime = trace.getDoubleGroup(10);
            double wallClock = trace.getDoubleGroup(11);
            this.publish(new AbortablePreClean(this.startOfConcurrentPhase, wallClock, cpuTime, wallClock, false));
            this.abortPrecleanDueToTime = false;
        }
        catch (Exception e) {
            LOGGER.warning("concurrent phase end choked on " + trace);
        }
    }

    private void startOfConcurrentPhase(GCLogTrace trace, String line) {
        this.startOfConcurrentPhase = trace.getDateTimeStamp();
    }

    private void endOfConcurrentPhase(GCLogTrace trace, String line) {
        DateTimeStamp endOfPhase = trace.getDateTimeStamp();
        this.endOfConcurrentPhase(trace, endOfPhase, 0);
    }

    private void endConcurrentPrecleanWithReferenceProcessing(GCLogTrace trace, String line) {
        GCLogTrace concurrentBlock = CONCURRENT_PHASE_END_BLOCK.parse(line);
        try {
            this.publish(new ConcurrentPreClean(this.startOfConcurrentPhase, concurrentBlock.getDoubleGroup(11), concurrentBlock.getDoubleGroup(7), concurrentBlock.getDoubleGroup(8)));
        }
        catch (Throwable t) {
            LOGGER.warning("Unable to extract data from " + trace.toString());
        }
    }

    private void endOfConcurrentPhase(GCLogTrace trace, DateTimeStamp timeStamp, int offset) {
        String phase = trace.getGroup(6 + offset);
        double cpuTime = trace.getDoubleGroup(7 + offset);
        double wallTime = trace.getDoubleGroup(8 + offset);
        double duration = timeStamp.toSeconds() - this.startOfConcurrentPhase.toSeconds();
        switch (phase) {
            case "mark": {
                this.publish(new ConcurrentMark(this.startOfConcurrentPhase, duration, cpuTime, wallTime));
                break;
            }
            case "preclean": {
                this.publish(new ConcurrentPreClean(this.startOfConcurrentPhase, duration, cpuTime, wallTime));
                break;
            }
            case "abortable-preclean": {
                this.publish(new AbortablePreClean(this.startOfConcurrentPhase, duration, cpuTime, wallTime, this.abortPrecleanDueToTime));
                this.abortPrecleanDueToTime = false;
                break;
            }
            case "sweep": {
                this.publish(new ConcurrentSweep(this.startOfConcurrentPhase, duration, cpuTime, wallTime));
                break;
            }
            case "reset": {
                this.publish(new ConcurrentReset(this.startOfConcurrentPhase, duration, cpuTime, wallTime));
                break;
            }
            default: {
                LOGGER.warning("concurrent phase choked on " + trace);
            }
        }
    }

    public void logMissedFirstRecordForEvent(String line) {
        LOGGER.log(Level.WARNING, "Missing initial record for: {0}", line);
    }

    private void clear() {
        this.garbageCollectionTypeForwardReference = null;
        this.gcCauseForwardReference = GCCause.UNKNOWN_GCCAUSE;
        this.fullGCTimeStamp = null;
        this.scavengeTimeStamp = null;
        this.youngMemoryPoolSummaryForwardReference = null;
        this.tenuredForwardReference = null;
        this.heapForwardReference = null;
        this.scavengeDurationForwardReference = 0.0;
        this.scavengeCPUSummaryForwardReference = null;
        this.referenceGCForwardReference = null;
        this.totalFreeSpaceForwardReference = 0L;
        this.maxChunkSizeForwardReference = 0L;
        this.numberOfBlocksForwardReference = 0;
        this.averageBlockSizeForwardReference = 0L;
        this.treeHeightForwardReference = 0;
    }

    public void publish(JVMEvent event, boolean drain, boolean clear) {
        this.publish(event, clear);
        if (drain) {
            for (GenerationalGCPauseEvent pauseEvent : this.queue) {
                this.publish(pauseEvent, false);
            }
            this.queue.clear();
        }
    }

    public void publish(JVMEvent event, boolean clear) {
        if (clear) {
            this.clear();
        }
        super.publish(ChannelName.GENERATIONAL_HEAP_PARSER_OUTBOX, event);
    }

    public void publish(GenerationalGCPauseEvent event) {
        if (this.inConcurrentPhase) {
            this.queue.add(event);
            this.clear();
        } else {
            this.publish(event, true);
        }
    }

    public void publish(CMSConcurrentEvent event) {
        this.inConcurrentPhase = false;
        this.publish(event, true, false);
    }

    @Override
    public boolean accepts(Diary diary) {
        return (diary.isGenerational() || diary.isCMS()) && !diary.isUnifiedLogging();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }
}

