/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp;

import com.azul.gulp.Gulp;
import com.azul.gulp.Printable;
import java.lang.reflect.Field;
import java.util.Objects;

public interface ResultProvider<T>
extends Printable {
    default public T result() {
        Field resultField = Helper.getResultField(this.getClass());
        try {
            Object casted = resultField.get(this);
            return (T)casted;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    default public String toPrintString() {
        return Objects.toString(this.result());
    }

    public static class Helper {
        private static Field getResultField(Class<?> aClass) {
            Field resultField = null;
            for (Field field : aClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Gulp.Result.class)) continue;
                if (resultField != null) {
                    throw new IllegalStateException();
                }
                resultField = field;
            }
            if (resultField == null) {
                throw new IllegalStateException("result not overridden or annotated: " + aClass);
            }
            resultField.setAccessible(true);
            return resultField;
        }
    }
}

