/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.foundations;

import com.azul.gulp.Enricher;
import com.azul.gulp.GenericAnalyzer;
import com.azul.gulp.GenericProcessor;
import com.azul.gulp.GulpLogStream;
import com.azul.gulp.LogProcessingException;
import com.azul.gulp.LogProcessor;
import com.azul.gulp.Normalizer;
import com.azul.gulp.PackagedAnalyzer;
import com.azul.gulp.Processor;
import com.azul.gulp.Result;
import com.azul.gulp.StreamProcessingException;
import com.azul.gulp.foundations.GulpLogExtension;
import com.azul.gulp.foundations.GulpLogStreamImpl;
import com.azul.gulp.foundations.StreamCore;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusHandler;
import com.azul.gulp.nexus.NexusImpl;
import com.azul.gulp.nexus.NexusUnhandler;
import com.azul.gulp.nexus.Plugin;
import com.azul.gulp.sources.PipelineConfiguration;
import com.azul.gulp.standardplugins.ComplexEventPlugin;
import com.azul.gulp.standardplugins.EventCapturePlugin;
import com.azul.gulp.standardplugins.InnerSubclassPlugin;
import com.azul.gulp.standardplugins.NormalizerPlugin;
import com.azul.gulp.standardplugins.ProcessorPlugin;
import com.azul.gulp.standardplugins.UnhandledPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class GulpLogBase<C extends GulpLogExtension<C>>
implements GulpLogExtension<C> {
    private static final int DEFAULT_COLLECTION_SIZE = 64;
    private static final PipelineConfiguration PLAIN_CONFIG = new PipelineConfiguration();
    private final PipelineConfiguration pipelineConfig;
    protected static final Plugin[] NO_PLUGINS = new Plugin[0];

    protected GulpLogBase() {
        this(PLAIN_CONFIG);
    }

    protected GulpLogBase(PipelineConfiguration normalizers) {
        this.pipelineConfig = normalizers;
    }

    protected abstract List<Class<?>> coreTypes();

    final List<Plugin> corePlugins() {
        return Arrays.asList(new InnerSubclassPlugin(), new ComplexEventPlugin(), new ProcessorPlugin(), new UnhandledPlugin(), new NormalizerPlugin(), new EventCapturePlugin());
    }

    protected List<Plugin> additionalPlugins() {
        return Collections.emptyList();
    }

    private Nexus createEngine() {
        List<Plugin> corePlugins = this.corePlugins();
        List<Plugin> additionalPlugins = this.additionalPlugins();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(corePlugins.size() + additionalPlugins.size());
        plugins.addAll(corePlugins);
        plugins.addAll(additionalPlugins);
        NexusImpl engine = new NexusImpl(this.coreTypes(), plugins);
        this.pipelineConfig.configure(engine);
        return engine;
    }

    protected final PipelineConfiguration normalizers() {
        return this.pipelineConfig;
    }

    protected abstract C createOffspring(PipelineConfiguration var1);

    protected abstract void run(Nexus var1) throws Exception;

    @Override
    public final <T> C normalize(Class<T> type, Normalizer<T> normalizer) {
        return this.createOffspring(this.pipelineConfig.add(type, normalizer));
    }

    @Override
    public final <T, V> C enrich(Class<T> inputType, Class<V> enrichmentType, Enricher<? super T, ? extends V> enricher) {
        return this.createOffspring(this.pipelineConfig.append(inputType, enrichmentType, enricher));
    }

    @Override
    public final <T> GulpLogStream<T> select(final Class<? extends T> dataClass) {
        return new GulpLogStreamImpl(new StreamCore<T>(){

            @Override
            protected void processImpl(final Processor<? super T> processor) throws StreamProcessingException {
                Nexus engine = GulpLogBase.this.createEngine();
                engine.handle(dataClass, new NexusHandler<T>(){

                    @Override
                    public void init(Nexus engine) throws Exception {
                        engine.inject(processor);
                    }

                    @Override
                    public void handle(T value) throws Exception {
                        processor.process(value);
                    }
                });
                try {
                    GulpLogBase.this.run(engine);
                }
                catch (StreamProcessingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new StreamProcessingException(e);
                }
            }
        });
    }

    @Override
    public final <R> Result<R> analyze(PackagedAnalyzer<R> analyzer) {
        return new Result(analyzer.analyze(this));
    }

    @Override
    public final <R> Result<R> analyze(GenericAnalyzer<R> analyzer) {
        this.process(analyzer);
        return new Result(analyzer);
    }

    @Override
    public final Result process(GenericProcessor processor) throws LogProcessingException {
        Nexus engine = this.createEngine();
        engine.connect(processor);
        try {
            this.run(engine);
        }
        catch (LogProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LogProcessingException(e);
        }
        return new Result(processor);
    }

    @Override
    public final Result process(LogProcessor.Provider provider) {
        return this.process(provider.get());
    }

    @Override
    public final Result process(LogProcessor logProcessor) throws LogProcessingException {
        final class NexusUnhandlerAdapter
        implements NexusUnhandler {
            private final Processor rawProcessor;

            public NexusUnhandlerAdapter(Processor rawProcessor) {
                this.rawProcessor = rawProcessor;
            }

            @Override
            public void init(Nexus nexus) {
                nexus.inject(this.rawProcessor);
            }

            public void unhandle(Object value) throws Exception {
                this.rawProcessor.process(value);
            }
        }
        final class NexusHandlerAdapter
        implements NexusHandler {
            private final Processor rawProcessor;

            public NexusHandlerAdapter(Processor rawProcessor) {
                this.rawProcessor = rawProcessor;
            }

            @Override
            public void init(Nexus nexus) {
                nexus.inject(this.rawProcessor);
            }

            public void handle(Object value) throws Exception {
                this.rawProcessor.process(value);
            }
        }
        Processor<?> rawUnhandledProcessor;
        Processor<?> rawProcessor;
        Class<?> rawKlass;
        Class<?> klass;
        Nexus engine = this.createEngine();
        engine.inject(logProcessor);
        Iterator<Class<?>> iterator = logProcessor.requiredTypes().iterator();
        while (iterator.hasNext()) {
            rawKlass = klass = iterator.next();
            rawProcessor = logProcessor.processorFor(klass);
            if (rawProcessor != null) {
                engine.handle(rawKlass, new NexusHandlerAdapter(rawProcessor));
            }
            if ((rawUnhandledProcessor = logProcessor.unhandledProcessorFor(klass)) == null) continue;
            engine.unhandle(rawKlass, new NexusUnhandlerAdapter(rawUnhandledProcessor));
        }
        iterator = logProcessor.optionalTypes().iterator();
        while (iterator.hasNext()) {
            rawKlass = klass = iterator.next();
            rawProcessor = logProcessor.processorFor(klass);
            if (rawProcessor != null) {
                engine.handle(rawKlass, new NexusHandlerAdapter(rawProcessor));
            }
            if ((rawUnhandledProcessor = logProcessor.unhandledProcessorFor(klass)) == null) continue;
            engine.unhandle(rawKlass, new NexusUnhandlerAdapter(rawUnhandledProcessor));
        }
        try {
            this.run(engine);
        }
        catch (LogProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LogProcessingException(e);
        }
        return new Result(logProcessor);
    }

    public final C preprocess(GenericProcessor preprocessor) {
        return this.createOffspring(this.pipelineConfig.add(preprocessor));
    }

    @Override
    public <T> Result<T> get(Class<T> analysis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public C prefetch() {
        throw new UnsupportedOperationException("prefetch");
    }
}

