/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.matching;

import com.azul.gulp.matching.Match;
import com.azul.gulp.matching.Pattern;
import com.azul.gulp.matching.PatternFragment;
import com.azul.gulp.nexus.FlexNexusHandler;
import com.azul.gulp.nexus.Nexus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PatternHandler
extends FlexNexusHandler {
    private final List<PatternFragment> fragments = this.pattern().fragments();
    private final Launcher launcher;
    private Nexus engine;

    public PatternHandler() {
        Launcher launcher;
        if (this.fragments.isEmpty()) {
            throw new IllegalStateException();
        }
        if (this.fragments.size() == 1) {
            launcher = this.fragments.get(0).isMany() ? new MatchManyTrivialLauncher() : new MatchOneTrivialLauncher();
        } else {
            throw new UnsupportedOperationException();
        }
        this.launcher = launcher;
    }

    protected abstract Pattern pattern();

    protected abstract void match(Match var1) throws Exception;

    @Override
    public void init(Nexus engine) throws Exception {
        this.engine = engine;
        for (PatternFragment fragment : this.fragments) {
            engine.require(fragment.type());
        }
    }

    @Override
    public final Class<?> type() {
        return this.fragments.get(0).type();
    }

    public final void handle(Object value) throws Exception {
        this.launcher.handle(this.engine, value);
    }

    @Override
    public void finish() throws Exception {
        this.launcher.finish();
    }

    protected final class NonTrivialLauncher
    extends Launcher {
        private final List<PatternFragment> fragments;

        NonTrivialLauncher(List<PatternFragment> fragments) {
            this.fragments = fragments;
        }

        @Override
        void handle(Nexus engine, Object value) throws Exception {
            throw new UnsupportedOperationException("unfinished");
        }

        @Override
        void finish() throws Exception {
        }
    }

    protected class MatchManyTrivialLauncher
    extends Launcher {
        private final List<Object> list;

        protected MatchManyTrivialLauncher() {
            this.list = new ArrayList<Object>();
        }

        @Override
        void handle(Nexus engine, Object value) {
            this.list.add(value);
        }

        @Override
        void finish() throws Exception {
            Match match = new Match(){

                @Override
                public <T> T get(int index) {
                    throw new IllegalStateException();
                }

                @Override
                public final <T> List<T> list(int index) {
                    return Collections.singletonList(this.get(index));
                }
            };
            PatternHandler.this.match(match);
        }
    }

    protected class MatchOneTrivialLauncher
    extends Launcher {
        protected MatchOneTrivialLauncher() {
        }

        @Override
        void handle(Nexus engine, final Object value) throws Exception {
            Match match = new Match(){

                @Override
                public <T> T get(int index) {
                    if (index < 0 || index > 1) {
                        throw new IllegalArgumentException();
                    }
                    Object castedValue = value;
                    return (T)castedValue;
                }

                @Override
                public final <T> List<T> list(int index) {
                    throw new IllegalStateException();
                }
            };
            PatternHandler.this.match(match);
        }

        @Override
        void finish() {
        }
    }

    protected abstract class Launcher {
        protected Launcher() {
        }

        abstract void handle(Nexus var1, Object var2) throws Exception;

        abstract void finish() throws Exception;
    }
}

