/*
 * Decompiled with CFR 0.152.
 */
package com.azul.gulp.sources;

import com.azul.gulp.Enricher;
import com.azul.gulp.GenericProcessor;
import com.azul.gulp.Normalizer;
import com.azul.gulp.nexus.Nexus;
import com.azul.gulp.nexus.NexusEmitter;
import com.azul.gulp.nexus.NexusNormalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class PipelineConfiguration {
    public static final PipelineConfiguration EMPTY = new PipelineConfiguration();
    private final List<Class<?>> normalizedTypes;
    private final List<NexusNormalizer<?>> normalizers;
    private final List<GenericProcessor> preprocessors;
    private final List<Class<? extends GenericProcessor>> preprocessorClasses;

    public PipelineConfiguration() {
        this.normalizedTypes = Collections.emptyList();
        this.normalizers = Collections.emptyList();
        this.preprocessors = Collections.emptyList();
        this.preprocessorClasses = Collections.emptyList();
    }

    private <T> PipelineConfiguration(PipelineConfiguration baseConfig, Class<T> type, NexusNormalizer<T> normalizer) {
        this.normalizedTypes = new ArrayList(baseConfig.normalizedTypes.size() + 1);
        this.normalizers = new ArrayList(baseConfig.normalizers.size() + 1);
        this.normalizedTypes.addAll(baseConfig.normalizedTypes);
        this.normalizers.addAll(baseConfig.normalizers);
        this.normalizedTypes.add(type);
        this.normalizers.add(normalizer);
        this.preprocessors = baseConfig.preprocessors;
        this.preprocessorClasses = baseConfig.preprocessorClasses;
    }

    private <T> PipelineConfiguration(PipelineConfiguration baseConfig, GenericProcessor preprocessor) {
        this.normalizedTypes = baseConfig.normalizedTypes;
        this.normalizers = baseConfig.normalizers;
        this.preprocessorClasses = baseConfig.preprocessorClasses;
        this.preprocessors = new ArrayList<GenericProcessor>(baseConfig.preprocessors.size() + 1);
        this.preprocessors.addAll(baseConfig.preprocessors);
        this.preprocessors.add(preprocessor);
    }

    private <T> PipelineConfiguration(PipelineConfiguration baseConfig, Class<? extends GenericProcessor> preprocessorClass) {
        this.normalizedTypes = baseConfig.normalizedTypes;
        this.normalizers = baseConfig.normalizers;
        this.preprocessors = baseConfig.preprocessors;
        this.preprocessorClasses = new ArrayList<Class<? extends GenericProcessor>>(baseConfig.preprocessorClasses.size() + 1);
        this.preprocessorClasses.addAll(baseConfig.preprocessorClasses);
        this.preprocessorClasses.add(preprocessorClass);
    }

    private <T> PipelineConfiguration add(Class<T> type, NexusNormalizer<T> normalizer) {
        return new PipelineConfiguration(this, type, normalizer);
    }

    public final <T> PipelineConfiguration add(Class<T> type, final Normalizer<T> normalizer) {
        return this.add(type, new NexusNormalizer<T>(){

            @Override
            public void init(Nexus nexus) throws Exception {
                nexus.inject(normalizer);
            }

            @Override
            public final T normalize(T value) throws Exception {
                return normalizer.normalize(value);
            }
        });
    }

    public final <T, V> PipelineConfiguration append(final Class<T> inputType, final Class<V> outputType, final Enricher<? super T, ? extends V> enricher) {
        return this.add(inputType, new NexusNormalizer<T>(){
            private NexusEmitter<V> emitter;

            @Override
            public final void init(Nexus ctx) throws Exception {
                ctx.inject(enricher);
                ctx.require(inputType);
                this.emitter = ctx.getEmitter(outputType);
            }

            @Override
            public final T normalize(T value) throws Exception {
                Object enrichment = enricher.enrichment(value);
                if (enrichment != null) {
                    this.emitter.fire(enrichment);
                }
                return value;
            }
        });
    }

    public final PipelineConfiguration add(GenericProcessor preprocessor) {
        return new PipelineConfiguration(this, preprocessor);
    }

    public final PipelineConfiguration addPreprocessor(Class<? extends GenericProcessor> preprocessorClass) {
        return new PipelineConfiguration(this, preprocessorClass);
    }

    public final void configure(Nexus engine) {
        Iterator<Class<?>> typesIterator = this.normalizedTypes.iterator();
        Iterator<NexusNormalizer<?>> normalizerIterator = this.normalizers.iterator();
        while (typesIterator.hasNext()) {
            Class<?> type = typesIterator.next();
            NexusNormalizer<?> nexusNormalizer = normalizerIterator.next();
            engine.normalize(type, nexusNormalizer);
        }
        for (GenericProcessor genericProcessor : this.preprocessors) {
            engine.connect(genericProcessor);
        }
        for (Class clazz : this.preprocessorClasses) {
            engine.get(clazz);
        }
    }
}

