/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.codeprofile;

import com.azul.jvm.klass.PersistentKlassId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class KlassHistogram {
    private final List<Entry> entries;

    public KlassHistogram(List<PersistentKlassId> klasses, List<Integer> counts) {
        if (klasses.size() != counts.size()) {
            throw new IllegalArgumentException("classes and counts lists must have equal length");
        }
        this.entries = new ArrayList<Entry>(klasses.size());
        for (int i = 0; i < klasses.size(); ++i) {
            this.entries.add(new Entry(klasses.get(i), counts.get(i)));
        }
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public Stream<Entry> entries() {
        return this.entries.stream();
    }

    public boolean hasClassIdInKlassHistogram(PersistentKlassId persistentKlassId) {
        return this.entries.stream().anyMatch(el -> el.klassId == persistentKlassId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('{');
        boolean first = true;
        for (Entry entry : this.entries) {
            sb.append(entry.klassId().toString()).append('=').append(entry.count());
            if (first) {
                first = false;
                continue;
            }
            sb.append(", ");
        }
        return sb.append('}').toString();
    }

    public static final class Entry {
        private final PersistentKlassId klassId;
        private final int count;

        private Entry(PersistentKlassId klassId, int count) {
            this.klassId = Objects.requireNonNull(klassId, "klassId");
            this.count = count;
        }

        public PersistentKlassId klassId() {
            return this.klassId;
        }

        public int count() {
            return this.count;
        }
    }
}

