/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.compile;

import com.azul.jvm.codeprofile.CodeProfileId;
import com.azul.jvm.compile.Compilation;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.CompilationTier;
import com.azul.jvm.compile.CompilationTrigger;
import com.azul.jvm.compile.OptLevel;
import com.azul.jvm.compile.StashFlavor;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.PersistentMethodId;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;

public class CompilationBuilder
extends Compilation {
    public CompilationBuilder(CompilationId id) {
        super(id);
    }

    public CompilationBuilder setMethodId(PersistentMethodId methodId) {
        this.methodId = methodId;
        return this;
    }

    public CompilationBuilder setMethodName(String fullName) {
        this.methodName = fullName;
        return this;
    }

    public void setOsr(int osrBci) {
        this.osrBci = osrBci;
    }

    public CompilationBuilder setTier(CompilationTier tier) {
        this.tier = tier;
        return this;
    }

    public CompilationBuilder setTrigger(CompilationTrigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public CompilationBuilder setStashFlavor(StashFlavor flavor) {
        this.stashFlavor = flavor;
        return this;
    }

    public CompilationBuilder setOptLevel(OptLevel optLevel) {
        this.optLevel = optLevel;
        return this;
    }

    public Set<PersistentKlassId> getMutableLoadedKlasses() {
        return this.loadedKlasses;
    }

    public CompilationBuilder addLoadedKlass(PersistentKlassId klassId) {
        Objects.requireNonNull(klassId, "klassId");
        this.loadedKlasses.add(klassId);
        return this;
    }

    public Set<PersistentKlassId> getMutableLinkedKlasses() {
        return this.linkedKlasses;
    }

    public CompilationBuilder addLinkedKlass(PersistentKlassId klassId) {
        Objects.requireNonNull(klassId, "klassId");
        this.linkedKlasses.add(klassId);
        return this;
    }

    public Set<PersistentKlassId> getMutableInitializedKlasses() {
        return this.initializedKlasses;
    }

    public CompilationBuilder addInitializedKlass(PersistentKlassId klassId) {
        Objects.requireNonNull(klassId, "klassId");
        this.initializedKlasses.add(klassId);
        return this;
    }

    public Set<PersistentKlassId> getMutableHierarchyKlasses() {
        return this.hierarchyKlasses;
    }

    public CompilationBuilder addHierarchy(PersistentKlassId klassId) {
        Objects.requireNonNull(klassId, "klassId");
        this.hierarchyKlasses.add(klassId);
        return this;
    }

    public Set<PersistentMethodId> getMutableInlinedMethods() {
        return this.inlinedMethods;
    }

    public CompilationBuilder addInlinedMethod(PersistentMethodId methodId) {
        Objects.requireNonNull(methodId, "methodId");
        this.inlinedMethods.add(methodId);
        return this;
    }

    public Set<CodeProfileId> getMutableCodeProfiles() {
        return this.codeProfiles;
    }

    public CompilationBuilder addCodeProfile(CodeProfileId codeProfileId) {
        Objects.requireNonNull(codeProfileId, "codeProfileId");
        this.codeProfiles.add(codeProfileId);
        return this;
    }

    public CompilationBuilder setSuccessfulResult(long blobSize) {
        this.result = "success";
        this.blobSize = blobSize;
        return this;
    }

    public CompilationBuilder setFailure(String reason) {
        this.result = reason;
        return this;
    }

    public CompilationBuilder setCpuTime(Duration cpuTime) {
        this.cpuTime = cpuTime;
        return this;
    }

    public CompilationBuilder setWallTime(Duration wallTime) {
        this.wallTime = wallTime;
        return this;
    }

    public CompilationBuilder setWaitTime(Duration waitTime) {
        this.waitTime = waitTime;
        return this;
    }
}

