/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.klass;

import com.azul.jvm.klass.KlassKind;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoaderId;
import java.util.Objects;
import java.util.regex.Pattern;

public class Klass {
    private static final Pattern LAMBDA_FORM_PATTERN = Pattern.compile("java\\.lang\\.invoke\\.LambdaForm\\$(MH|BMH|DMH|NFI|LFI)/0x[0-9a-fA-F]+");
    private final PersistentKlassId id;
    PersistentKlassId prevId;
    KlassKind kind;
    String name;
    KlassLoaderId definingLoaderId;
    KlassLoaderId initiatingLoaderId;

    public Klass(PersistentKlassId id) {
        this.id = Objects.requireNonNull(id, "id");
        this.name = "NO_NAME_" + id;
    }

    public PersistentKlassId id() {
        return this.id;
    }

    public PersistentKlassId prevId() {
        return this.prevId;
    }

    public KlassKind kind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public KlassLoaderId getDefiningLoaderId() {
        return this.definingLoaderId;
    }

    public KlassLoaderId getInitiatingLoaderId() {
        return this.initiatingLoaderId;
    }

    public boolean isLambdaForm() {
        return LAMBDA_FORM_PATTERN.matcher(this.name).find();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Class ").append(this.name);
        if (this.kind != null && this.kind != KlassKind.CLASS) {
            sb.append(" (").append(this.kind.persistentId).append(')');
        }
        return sb.toString();
    }
}

