/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.time;

import com.azul.jvm.time.BaseTime;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class EpochTime
implements BaseTime<EpochTime> {
    public static final EpochTime MIN = EpochTime.fromMillis(0L);
    public static final EpochTime MAX = EpochTime.fromMillis(Long.MAX_VALUE);
    private static final String PREFERRED_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public final long millis;
    public final long nanos;
    final TimeZone timeZone;
    private static ThreadLocal<TimeZone> hourOffsetTimeZoneCache = new ThreadLocal();

    public static EpochTime min(EpochTime lhs, EpochTime rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return lhs.compareTo(rhs) <= 0 ? lhs : rhs;
    }

    public static EpochTime max(EpochTime lhs, EpochTime rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return lhs.compareTo(rhs) >= 0 ? lhs : rhs;
    }

    public static EpochTime fromSeconds(long secs) {
        return EpochTime.fromMillis(TimeUnit.SECONDS.toMillis(secs));
    }

    public static EpochTime fromSeconds(long secs, int timeZoneOffset) {
        return EpochTime.fromMillis(TimeUnit.SECONDS.toMillis(secs), timeZoneOffset);
    }

    public static EpochTime fromSecondsWithOffset(long secs, String offsetId) {
        return EpochTime.fromMillisWithOffset(TimeUnit.SECONDS.toMillis(secs), offsetId);
    }

    public static EpochTime fromMillis(long millis) {
        return new EpochTime(millis);
    }

    public static EpochTime fromMillis(long millis, int timeZoneOffset) {
        return new EpochTime(millis, timeZoneOffset);
    }

    public static EpochTime fromMillisWithOffset(long millis, String offsetId) {
        return new EpochTime(millis, EpochTime.timeZoneFromOffsetId(millis, offsetId));
    }

    public static EpochTime fromMillis(long millis, TimeZone timeZone) {
        return new EpochTime(millis, timeZone);
    }

    private static long nanosToMillis(long nanos) {
        return TimeUnit.NANOSECONDS.toMillis(nanos);
    }

    public static EpochTime fromNanos(long nanos) {
        return new EpochTime(EpochTime.nanosToMillis(nanos), nanos);
    }

    public static EpochTime fromNanos(long nanos, int timeZone) {
        return new EpochTime(EpochTime.nanosToMillis(nanos), nanos, timeZone);
    }

    public static EpochTime fromNanosWithOffset(long nanos, String offsetId) {
        long millis = EpochTime.nanosToMillis(nanos);
        return new EpochTime(EpochTime.nanosToMillis(nanos), nanos, EpochTime.timeZoneFromOffsetId(millis, offsetId));
    }

    public static EpochTime fromNanos(long nanos, TimeZone timeZone) {
        return new EpochTime(EpochTime.nanosToMillis(nanos), nanos, timeZone);
    }

    public static EpochTime fromString(String str) {
        return new EpochTime(str);
    }

    public static EpochTime fromString(String simpleFormat, String str) {
        return new EpochTime(simpleFormat, str);
    }

    public static EpochTime fromString(DateFormat format, String str) {
        return new EpochTime(format, str);
    }

    public static String extractOffsetId(String str) {
        return str.substring(str.length() - 5);
    }

    public EpochTime(String str) {
        Date date;
        SimpleDateFormat format = new SimpleDateFormat(PREFERRED_DATE_FORMAT);
        try {
            date = format.parse(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        this.millis = date.getTime();
        this.nanos = TimeUnit.MILLISECONDS.toNanos(this.millis);
        String zoneOffsetId = str.substring(str.length() - 5);
        this.timeZone = EpochTime.timeZoneFromOffsetId(this.millis, zoneOffsetId);
    }

    private static TimeZone timeZoneFromOffsetId(long dateMillis, String offsetId) {
        int offsetNum = Integer.parseInt(offsetId);
        int hours = offsetNum / 100;
        int mins = offsetNum - hours * 100;
        return EpochTime.timeZoneFromOffset(dateMillis, hours, mins);
    }

    public EpochTime(String simpleFormat, String str) {
        this(new SimpleDateFormat(simpleFormat), str);
    }

    public EpochTime(DateFormat format, String str) {
        Date date;
        try {
            date = format.parse(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        this.millis = date.getTime();
        this.nanos = TimeUnit.MILLISECONDS.toNanos(this.millis);
        this.timeZone = null;
    }

    public EpochTime(long millis) {
        this.millis = millis;
        this.nanos = TimeUnit.MILLISECONDS.toNanos(millis);
        this.timeZone = null;
    }

    public EpochTime(long millis, TimeZone timeZone) {
        this.millis = millis;
        this.nanos = TimeUnit.MILLISECONDS.toNanos(millis);
        this.timeZone = timeZone;
    }

    public EpochTime(long millis, int timeZoneOffset) {
        this(millis, EpochTime.timeZoneFromOffset(millis, timeZoneOffset));
    }

    private EpochTime(long millis, long nanos) {
        this.millis = millis;
        this.nanos = nanos;
        this.timeZone = null;
    }

    private EpochTime(long millis, long nanos, int timeZoneOffset) {
        this.millis = millis;
        this.nanos = nanos;
        this.timeZone = EpochTime.timeZoneFromOffset(millis, timeZoneOffset);
    }

    private EpochTime(long millis, long nanos, TimeZone timeZone) {
        this.millis = millis;
        this.nanos = nanos;
        this.timeZone = timeZone;
    }

    private static TimeZone timeZoneFromOffset(long dateMillis, int timeZoneOffsetHrs) {
        return EpochTime.timeZoneFromOffset(dateMillis, timeZoneOffsetHrs, 0);
    }

    private static TimeZone timeZoneFromOffset(long dateMillis, int timeZoneOffsetHrs, int timeZoneOffsetMins) {
        long offset = TimeUnit.HOURS.toMillis(timeZoneOffsetHrs) + TimeUnit.MINUTES.toMillis(timeZoneOffsetMins);
        TimeZone lastTimeZone = hourOffsetTimeZoneCache.get();
        if (lastTimeZone != null && (long)lastTimeZone.getOffset(dateMillis) == offset) {
            return lastTimeZone;
        }
        for (String zoneId : TimeZone.getAvailableIDs()) {
            TimeZone zone = TimeZone.getTimeZone(zoneId);
            if ((long)zone.getOffset(dateMillis) != offset) continue;
            hourOffsetTimeZoneCache.set(zone);
            return zone;
        }
        throw new IllegalStateException();
    }

    @Override
    public final EpochTime add(long duration, TimeUnit unit) {
        long deltaMillis = unit.toMillis(duration);
        return new EpochTime(this.millis + deltaMillis, this.timeZone);
    }

    @Override
    public final EpochTime roundTo(long resolution, TimeUnit unit) {
        long divisor = unit.toMillis(resolution);
        if (divisor <= 1L) {
            return this;
        }
        long newMillis = this.millis / divisor * divisor;
        return new EpochTime(newMillis, this.timeZone);
    }

    @Override
    public final EpochTime roundTo(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: 
            case MICROSECONDS: 
            case MILLISECONDS: {
                return this;
            }
        }
        Date date = new Date(this.millis);
        int year = date.getYear();
        int month = date.getMonth();
        int dayOfMonth = date.getDate();
        int hours = 0;
        int mins = 0;
        int secs = 0;
        switch (unit) {
            case SECONDS: {
                secs = date.getSeconds();
            }
            case MINUTES: {
                mins = date.getMinutes();
            }
            case HOURS: {
                hours = date.getHours();
            }
        }
        Date roundedDate = new Date(year, month, dayOfMonth, hours, mins, secs);
        return new EpochTime(roundedDate.getTime(), this.timeZone);
    }

    @Override
    public final long diff(EpochTime that, TimeUnit unit) {
        if (unit == TimeUnit.NANOSECONDS) {
            return this.nanos - that.nanos;
        }
        if (unit == TimeUnit.MILLISECONDS) {
            return this.millis - that.millis;
        }
        long diffNanos = this.nanos - that.nanos;
        return unit.convert(diffNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public final int compareTo(long time) {
        return Long.compare(this.millis, time);
    }

    @Override
    public final int compareTo(EpochTime that) {
        return Long.compare(this.nanos, that.nanos);
    }

    public final int hashCode() {
        return (int)this.millis;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof EpochTime)) {
            return false;
        }
        EpochTime that = (EpochTime)obj;
        return this.nanos == that.nanos;
    }

    public final String toString() {
        return this.toString(PREFERRED_DATE_FORMAT);
    }

    public final String toTimeString() {
        return this.toTimeString(false);
    }

    public final String toTimeString(boolean showOffset) {
        if (showOffset) {
            return this.toString("HH:mm:ss.SSSZ");
        }
        return this.toString("HH:mm:ss.SSS");
    }

    public final String toString(String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        if (this.timeZone != null) {
            format.setTimeZone(this.timeZone);
        }
        return format.format(new Date(this.millis));
    }

    public Instant toInstant() {
        return Instant.ofEpochSecond(TimeUnit.NANOSECONDS.toSeconds(this.nanos), this.nanos % 1000000000L);
    }
}

