/*
 * Decompiled with CFR 0.152.
 */
package com.azul.jvm.time;

import com.azul.jvm.time.BaseTime;
import com.azul.jvm.time.TimeStep;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class TimeIterator<T extends BaseTime<T>>
implements Iterator<T> {
    private final T start;
    private final T end;
    private final TimeStep step;
    private T next;

    public TimeIterator(T start, T end, TimeStep step) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.next = this.start;
    }

    @Override
    public final boolean hasNext() {
        return this.next.compareTo(this.end) < 0;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T cur = this.next;
        this.next = cur.add(this.step);
        return cur;
    }
}

