/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.CompactionTimesAggregation;
import com.azul.log.gctoolkitInterface.dtos.CompactionTimesDTO;
import com.azul.log.gctoolkitInterface.general.enums.CompactionPhase;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.g1gc.G1FullGC;

@Aggregates(value={EventSource.G1GC})
public class CompactionTimesAggregator
extends Aggregator<CompactionTimesAggregation> {
    public CompactionTimesAggregator(CompactionTimesAggregation aggregation) {
        super(aggregation);
        this.register(G1FullGC.class, this::extractCompactionTimes);
    }

    private void extractCompactionTimes(G1FullGC event) {
        CompactionTimesDTO compactionTimeDTO = new CompactionTimesDTO();
        event.internalPhases().forEach(phaseName -> {
            CompactionPhase phase = CompactionPhase.fromString(phaseName);
            double phaseDuration = event.internalPhaseDuration((String)phaseName);
            switch (phase) {
                case MARK_LIVE_OBJECTS: {
                    compactionTimeDTO.setMarkLiveObjectsDuration(phaseDuration);
                    break;
                }
                case PREP_FOR_COMPACT: {
                    compactionTimeDTO.setPrepareForCompactionDuration(phaseDuration);
                    break;
                }
                case AdJUST_POINTERS: {
                    compactionTimeDTO.setAdjustPointersDuration(phaseDuration);
                    break;
                }
                case COMPACT_HEAP: {
                    compactionTimeDTO.setCompactHeapDuration(phaseDuration);
                }
            }
        });
        ((CompactionTimesAggregation)this.aggregation()).recordCompactionTime(event.getGarbageCollectionType(), compactionTimeDTO, event.getDateTimeStamp());
    }
}

