/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.HeapAndMetaspaceAggregator;
import com.azul.log.gctoolkitInterface.dtos.MemoryUsesDTO;
import com.azul.log.gctoolkitInterface.general.TimestampedDataSet;
import com.azul.log.model.api.LogUnits;
import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Collates;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.HashMap;

@Collates(value=HeapAndMetaspaceAggregator.class)
public class HeapAndMetaspaceAggregation
extends Aggregation {
    private final HashMap<GarbageCollectionTypes, TimestampedDataSet<MemoryUsesDTO>> data = new HashMap();

    public void recordMemoryUse(GarbageCollectionTypes gcType, MemoryUsesDTO heapUses, DateTimeStamp timeStamp) {
        this.calculateAllocationRates(heapUses, timeStamp);
        this.data.computeIfAbsent(gcType, key -> new TimestampedDataSet()).add(timeStamp, heapUses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordMemoryUseIfNotExist(GarbageCollectionTypes gcType, MemoryUsesDTO heapUses, DateTimeStamp timeStamp) {
        HashMap<GarbageCollectionTypes, TimestampedDataSet<MemoryUsesDTO>> hashMap = this.data;
        synchronized (hashMap) {
            this.data.computeIfAbsent(gcType, key -> new TimestampedDataSet()).addIfAbsent(timeStamp, heapUses);
        }
    }

    public HashMap<GarbageCollectionTypes, TimestampedDataSet<MemoryUsesDTO>> getData() {
        return this.data;
    }

    private void calculateAllocationRates(MemoryUsesDTO heapUses, DateTimeStamp timeStamp) {
        if (this.data.isEmpty()) {
            return;
        }
        TimestampedDataSet.Point prevRecord = this.data.values().stream().map(dataSet -> dataSet.getItems().get(dataSet.getItems().size() - 1)).reduce((p1, p2) -> p1.getRelativeTimestamp() > p2.getRelativeTimestamp() ? p1 : p2).get();
        double alloc = LogUnits.KILOBYTES.convertTo(heapUses.getHeapBefore() - ((MemoryUsesDTO)prevRecord.getValue()).getHeapAfter(), LogUnits.MEGABYTES);
        double timeDiff = timeStamp.getTimeStamp() - prevRecord.getRelativeTimestamp();
        if (timeDiff != 0.0) {
            double rate = alloc / timeDiff;
            heapUses.setInterCycleAllocationRate(rate);
        }
    }

    @Override
    public boolean hasWarning() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

