/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.PauseAggregator;
import com.azul.log.gctoolkitInterface.dtos.MarkDTO;
import com.azul.log.gctoolkitInterface.dtos.MinMutatorUtilizationDTO;
import com.azul.log.gctoolkitInterface.dtos.NMethodDTO;
import com.azul.log.gctoolkitInterface.dtos.PauseDataDTO;
import com.azul.log.gctoolkitInterface.dtos.RefsDTO;
import com.azul.log.gctoolkitInterface.dtos.SystemLoadDTO;
import com.azul.log.gctoolkitInterface.general.TimestampedDataSet;
import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Collates;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.HashMap;
import java.util.Map;

@Collates(value=PauseAggregator.class)
public class PauseAggregation
extends Aggregation {
    private final Map<GarbageCollectionTypes, TimestampedDataSet<PauseDataDTO>> data = new HashMap<GarbageCollectionTypes, TimestampedDataSet<PauseDataDTO>>();
    private TimestampedDataSet<MinMutatorUtilizationDTO> zgcMMUData = new TimestampedDataSet();
    private TimestampedDataSet<SystemLoadDTO> zgcLoadData = new TimestampedDataSet();
    private TimestampedDataSet<MarkDTO> zgcMarkData = new TimestampedDataSet();
    private TimestampedDataSet<NMethodDTO> zgcNMethodData = new TimestampedDataSet();
    private TimestampedDataSet<RefsDTO> zgcRefsData = new TimestampedDataSet();

    public void recordPauseDurationAndReason(GarbageCollectionTypes gcType, PauseDataDTO pauseDataDTO, DateTimeStamp timeStamp) {
        this.calculateInterCycleDuration(gcType, pauseDataDTO, timeStamp);
        this.data.computeIfAbsent(gcType, k -> new TimestampedDataSet()).add(timeStamp, pauseDataDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordPauseDurationAndReasonIfNotExist(GarbageCollectionTypes gcType, PauseDataDTO pauseDataDTO, DateTimeStamp timeStamp) {
        this.calculateInterCycleDuration(gcType, pauseDataDTO, timeStamp);
        Map<GarbageCollectionTypes, TimestampedDataSet<PauseDataDTO>> map = this.data;
        synchronized (map) {
            this.data.computeIfAbsent(gcType, k -> new TimestampedDataSet()).addIfAbsent(timeStamp, pauseDataDTO);
        }
    }

    public void recordMMU(MinMutatorUtilizationDTO mmuDTO, DateTimeStamp timeStamp) {
        this.zgcMMUData.add(timeStamp, mmuDTO);
    }

    public void recordLoad(SystemLoadDTO loadDTO, DateTimeStamp timeStamp) {
        this.zgcLoadData.add(timeStamp, loadDTO);
    }

    public void recordMark(MarkDTO markDTO, DateTimeStamp timeStamp) {
        this.zgcMarkData.add(timeStamp, markDTO);
    }

    public void recordNMethod(NMethodDTO nMethodDTO, DateTimeStamp timeStamp) {
        this.zgcNMethodData.add(timeStamp, nMethodDTO);
    }

    public void recordRef(RefsDTO refsDTO, DateTimeStamp timeStamp) {
        this.zgcRefsData.add(timeStamp, refsDTO);
    }

    public Map<GarbageCollectionTypes, TimestampedDataSet<PauseDataDTO>> getData() {
        return this.data;
    }

    public TimestampedDataSet<MinMutatorUtilizationDTO> getMMUData() {
        return this.zgcMMUData;
    }

    public TimestampedDataSet<SystemLoadDTO> getLoadData() {
        return this.zgcLoadData;
    }

    public TimestampedDataSet<MarkDTO> getMarkData() {
        return this.zgcMarkData;
    }

    public TimestampedDataSet<NMethodDTO> getNMethodData() {
        return this.zgcNMethodData;
    }

    public TimestampedDataSet<RefsDTO> getRefsData() {
        return this.zgcRefsData;
    }

    private void calculateInterCycleDuration(GarbageCollectionTypes gcType, PauseDataDTO pauseDataDTO, DateTimeStamp timeStamp) {
        TimestampedDataSet<PauseDataDTO> prevRecords = this.data.get(gcType);
        if (prevRecords == null || prevRecords.isEmpty()) {
            return;
        }
        TimestampedDataSet.Point<PauseDataDTO> prevRecord = prevRecords.getItems().get(prevRecords.getItems().size() - 1);
        long interCycleDuration = (long)(timeStamp.getTimeStamp() - prevRecord.getRelativeTimestamp());
        pauseDataDTO.setInterCycleDuration(interCycleDuration);
    }

    @Override
    public boolean hasWarning() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

