/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gctoolkitInterface.aggregations;

import com.azul.log.gctoolkitInterface.aggregations.PauseAggregation;
import com.azul.log.gctoolkitInterface.dtos.MarkDTO;
import com.azul.log.gctoolkitInterface.dtos.MinMutatorUtilizationDTO;
import com.azul.log.gctoolkitInterface.dtos.NMethodDTO;
import com.azul.log.gctoolkitInterface.dtos.PauseDataDTO;
import com.azul.log.gctoolkitInterface.dtos.RefsDTO;
import com.azul.log.gctoolkitInterface.dtos.SystemLoadDTO;
import com.azul.log.gctoolkitInterface.general.enums.GenerationType;
import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.g1gc.G1GCConcurrentEvent;
import com.microsoft.gctoolkit.event.g1gc.G1GCPauseEvent;
import com.microsoft.gctoolkit.event.generational.CMSPauseEvent;
import com.microsoft.gctoolkit.event.generational.GenerationalGCPauseEvent;
import com.microsoft.gctoolkit.event.zgc.FullZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MajorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.MinorZGCCycle;
import com.microsoft.gctoolkit.event.zgc.ZGCCycle;
import com.microsoft.gctoolkit.event.zgc.ZGCMarkSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCNMethodSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCReferenceSummary;
import com.microsoft.gctoolkit.time.DateTimeStamp;

@Aggregates(value={EventSource.G1GC, EventSource.GENERATIONAL, EventSource.ZGC, EventSource.CMS_PREUNIFIED, EventSource.CMS_UNIFIED})
public class PauseAggregator
extends Aggregator<PauseAggregation> {
    public PauseAggregator(PauseAggregation aggregation) {
        super(aggregation);
        this.register(G1GCPauseEvent.class, this::process);
        this.register(G1GCConcurrentEvent.class, this::process);
        this.register(GenerationalGCPauseEvent.class, this::process);
        this.register(FullZGCCycle.class, this::process);
        this.register(MajorZGCCycle.class, this::process);
        this.register(MinorZGCCycle.class, this::process);
        this.register(CMSPauseEvent.class, this::process);
    }

    private void process(G1GCPauseEvent event) {
        PauseDataDTO pauseDataDTO = new PauseDataDTO(event.getDuration(), event.getGCCause());
        ((PauseAggregation)this.aggregation()).recordPauseDurationAndReason(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
    }

    private void process(G1GCConcurrentEvent event) {
        PauseDataDTO pauseDataDTO = new PauseDataDTO(event.getDuration(), event.getGCCause());
        ((PauseAggregation)this.aggregation()).recordPauseDurationAndReason(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
    }

    private void process(GenerationalGCPauseEvent event) {
        PauseDataDTO pauseDataDTO = new PauseDataDTO(event.getDuration(), event.getGCCause());
        if (event.getGarbageCollectionType() == GarbageCollectionTypes.ParNew) {
            ((PauseAggregation)this.aggregation()).recordPauseDurationAndReasonIfNotExist(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
        } else {
            ((PauseAggregation)this.aggregation()).recordPauseDurationAndReason(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
        }
    }

    private void process(FullZGCCycle event) {
        ZGCReferenceSummary phantomRefSummary;
        ZGCReferenceSummary finalRefSummary;
        ZGCReferenceSummary weakRefSummary;
        ZGCReferenceSummary softRefSummary;
        ZGCNMethodSummary nMethodSummary;
        PauseDataDTO pauseDataDTO = new PauseDataDTO(event.getDuration(), event.getGCCause());
        ((PauseAggregation)this.aggregation()).recordPauseDurationAndReason(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
        MinMutatorUtilizationDTO mmuDTO = new MinMutatorUtilizationDTO(GenerationType.FULL, event.getMMU(2), event.getMMU(5), event.getMMU(10), event.getMMU(20), event.getMMU(50), event.getMMU(100));
        ((PauseAggregation)this.aggregation()).recordMMU(mmuDTO, event.getDateTimeStamp());
        SystemLoadDTO systemLoadDTO = new SystemLoadDTO(GenerationType.FULL, event.getLoadAverageAt(1), event.getLoadAverageAt(5), event.getLoadAverageAt(15));
        ((PauseAggregation)this.aggregation()).recordLoad(systemLoadDTO, event.getDateTimeStamp());
        ZGCMarkSummary markSummary = event.getMarkSummary();
        if (markSummary != null) {
            MarkDTO markDTO = new MarkDTO(GenerationType.FULL, markSummary.getStripes(), markSummary.getProactiveFlushes(), markSummary.getTerminatedFlushes(), markSummary.getCompletions(), markSummary.getContinuations());
            ((PauseAggregation)this.aggregation()).recordMark(markDTO, event.getDateTimeStamp());
        }
        if ((nMethodSummary = event.getNMethodSummary()) != null) {
            NMethodDTO nMethodDTO = new NMethodDTO(GenerationType.FULL, nMethodSummary.getRegistered(), nMethodSummary.getUnregistered());
            ((PauseAggregation)this.aggregation()).recordNMethod(nMethodDTO, event.getDateTimeStamp());
        }
        if ((softRefSummary = event.getSoftRefSummary()) != null) {
            RefsDTO softDTO = new RefsDTO(GenerationType.FULL, RefsDTO.RefType.SOFT, softRefSummary.getEncountered(), softRefSummary.getDiscovered(), softRefSummary.getEnqueued());
            ((PauseAggregation)this.aggregation()).recordRef(softDTO, event.getDateTimeStamp());
        }
        if ((weakRefSummary = event.getWeakRefSummary()) != null) {
            RefsDTO weakDTO = new RefsDTO(GenerationType.FULL, RefsDTO.RefType.WEAK, weakRefSummary.getEncountered(), weakRefSummary.getDiscovered(), weakRefSummary.getEnqueued());
            ((PauseAggregation)this.aggregation()).recordRef(weakDTO, event.getDateTimeStamp());
        }
        if ((finalRefSummary = event.getFinalRefSummary()) != null) {
            RefsDTO finalDTO = new RefsDTO(GenerationType.FULL, RefsDTO.RefType.FINAL, finalRefSummary.getEncountered(), finalRefSummary.getDiscovered(), finalRefSummary.getEnqueued());
            ((PauseAggregation)this.aggregation()).recordRef(finalDTO, event.getDateTimeStamp());
        }
        if ((phantomRefSummary = event.getPhantomRefSummary()) != null) {
            RefsDTO phantomDTO = new RefsDTO(GenerationType.FULL, RefsDTO.RefType.PHANTOM, phantomRefSummary.getEncountered(), phantomRefSummary.getDiscovered(), phantomRefSummary.getEnqueued());
            ((PauseAggregation)this.aggregation()).recordRef(phantomDTO, event.getDateTimeStamp());
        }
    }

    void processZGCCycle(ZGCCycle cycle, GenerationType generation, DateTimeStamp timeStamp) {
        ZGCReferenceSummary phantomRefSummary;
        ZGCReferenceSummary finalRefSummary;
        ZGCReferenceSummary weakRefSummary;
        ZGCReferenceSummary softRefSummary;
        ZGCNMethodSummary nMethodSummary;
        MinMutatorUtilizationDTO mmuDTO = new MinMutatorUtilizationDTO(generation, cycle.getMMU(2), cycle.getMMU(5), cycle.getMMU(10), cycle.getMMU(20), cycle.getMMU(50), cycle.getMMU(100));
        ((PauseAggregation)this.aggregation()).recordMMU(mmuDTO, timeStamp);
        SystemLoadDTO systemLoadDTO = new SystemLoadDTO(generation, cycle.getLoadAverageAt(1), cycle.getLoadAverageAt(5), cycle.getLoadAverageAt(15));
        ((PauseAggregation)this.aggregation()).recordLoad(systemLoadDTO, timeStamp);
        ZGCMarkSummary markSummary = cycle.getMarkSummary();
        if (markSummary != null) {
            MarkDTO markDTO = new MarkDTO(generation, markSummary.getStripes(), markSummary.getProactiveFlushes(), markSummary.getTerminatedFlushes(), markSummary.getCompletions(), markSummary.getContinuations());
            ((PauseAggregation)this.aggregation()).recordMark(markDTO, timeStamp);
        }
        if ((nMethodSummary = cycle.getNMethodSummary()) != null) {
            NMethodDTO nMethodDTO = new NMethodDTO(generation, nMethodSummary.getRegistered(), nMethodSummary.getUnregistered());
            ((PauseAggregation)this.aggregation()).recordNMethod(nMethodDTO, timeStamp);
        }
        if ((softRefSummary = cycle.getSoftRefSummary()) != null) {
            RefsDTO softDTO = new RefsDTO(generation, RefsDTO.RefType.SOFT, softRefSummary.getEncountered(), softRefSummary.getDiscovered(), softRefSummary.getEnqueued());
            ((PauseAggregation)this.aggregation()).recordRef(softDTO, timeStamp);
        }
        if ((weakRefSummary = cycle.getWeakRefSummary()) != null) {
            RefsDTO weakDTO = new RefsDTO(generation, RefsDTO.RefType.WEAK, weakRefSummary.getEncountered(), weakRefSummary.getDiscovered(), weakRefSummary.getEnqueued());
            ((PauseAggregation)this.aggregation()).recordRef(weakDTO, timeStamp);
        }
        if ((finalRefSummary = cycle.getFinalRefSummary()) != null) {
            RefsDTO finalDTO = new RefsDTO(generation, RefsDTO.RefType.FINAL, finalRefSummary.getEncountered(), finalRefSummary.getDiscovered(), finalRefSummary.getEnqueued());
            ((PauseAggregation)this.aggregation()).recordRef(finalDTO, timeStamp);
        }
        if ((phantomRefSummary = cycle.getPhantomRefSummary()) != null) {
            RefsDTO phantomDTO = new RefsDTO(generation, RefsDTO.RefType.PHANTOM, phantomRefSummary.getEncountered(), phantomRefSummary.getDiscovered(), phantomRefSummary.getEnqueued());
            ((PauseAggregation)this.aggregation()).recordRef(phantomDTO, timeStamp);
        }
    }

    private void process(MajorZGCCycle event) {
        PauseDataDTO pauseDataDTO = new PauseDataDTO(event.getDuration(), event.getGCCause());
        ((PauseAggregation)this.aggregation()).recordPauseDurationAndReason(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
        this.processZGCCycle(event.getYoungCycle(), GenerationType.YOUNG, event.getDateTimeStamp());
        this.processZGCCycle(event.getOldCycle(), GenerationType.OLD, event.getDateTimeStamp());
    }

    private void process(MinorZGCCycle event) {
        PauseDataDTO pauseDataDTO = new PauseDataDTO(event.getDuration(), event.getGCCause());
        ((PauseAggregation)this.aggregation()).recordPauseDurationAndReason(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
        this.processZGCCycle(event.getYoungCycle(), GenerationType.YOUNG, event.getDateTimeStamp());
    }

    private void process(CMSPauseEvent event) {
        PauseDataDTO pauseDataDTO = new PauseDataDTO(event.getDuration(), event.getGCCause());
        ((PauseAggregation)this.aggregation()).recordPauseDurationAndReasonIfNotExist(event.getGarbageCollectionType(), pauseDataDTO, event.getDateTimeStamp());
    }
}

