/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.actions;

import com.azul.log.gui.model.ChartTypeSelectorModel;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.utils.UIUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jfree.chart.JFreeChart;
import org.openide.util.Lookup;

public final class ChartTypeSelectionAction
extends AbstractAction {
    final ChartTypeSelectorModel chartTypeSelectorModel = ChartTypeSelectorModel.getModel();

    public ChartTypeSelectionAction() {
        this.updateButton();
    }

    public static JComponent getToolbarPresenter() {
        ChartTypeSelectionAction chartTypeSelectionAction = new ChartTypeSelectionAction();
        JButton button = new JButton(chartTypeSelectionAction);
        button.setEnabled(false);
        button.setPreferredSize(new Dimension(52, 44));
        button.putClientProperty("autoscale", Boolean.TRUE);
        Lookup.Result<JFreeChart> result = Context.lookupResult(JFreeChart.class);
        result.addLookupListener(l -> button.setEnabled(!result.allInstances().isEmpty()));
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFreeChart chart = Context.lookup(JFreeChart.class);
        if (chart != null) {
            if (this.chartTypeSelectorModel.getPreferredPlotType() == ChartTypeSelectorModel.CHART_TYPE.SCATTER) {
                this.chartTypeSelectorModel.setPreferredPlotType(ChartTypeSelectorModel.CHART_TYPE.LINE);
            } else {
                this.chartTypeSelectorModel.setPreferredPlotType(ChartTypeSelectorModel.CHART_TYPE.SCATTER);
            }
            this.updateButton();
            chart.fireChartChanged();
        }
    }

    private void updateButton() {
        if (ChartTypeSelectorModel.getModel().getPreferredPlotType() == ChartTypeSelectorModel.CHART_TYPE.SCATTER) {
            this.putValue("SmallIcon", UIUtils.loadIcon("/buttons/line-chart.png"));
            this.putValue("ShortDescription", "Switch to Line Chart");
        } else {
            this.putValue("SmallIcon", UIUtils.loadIcon("/buttons/scatter-chart.png"));
            this.putValue("ShortDescription", "Switch to Scatter Plot");
        }
    }
}

