/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.actions;

import com.azul.log.gui.actions.GlobalContextAction;
import com.azul.log.gui.model.TextSearchContext;
import com.azul.log.gui.utils.UIUtils;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class SearchTextActions {
    public static final AbstractAction FIND = new SearchTextAction("Find ...", 0, KeyStroke.getKeyStroke(70, UIUtils.MENU_SHORTCUT_KEY_MASK));
    public static final AbstractAction FIND_NEXT = new SearchTextAction("Find Next", 1, KeyStroke.getKeyStroke(71, UIUtils.MENU_SHORTCUT_KEY_MASK));
    public static final AbstractAction FIND_PREV = new SearchTextAction("Find Previous", 2, KeyStroke.getKeyStroke(71, UIUtils.MENU_SHORTCUT_KEY_MASK | 0x40));
    public static final AbstractAction CANCEL = new SearchTextAction(null, 3, null);

    private SearchTextActions() {
    }

    public static JComponent getMenuPresenter(AbstractAction action) {
        JMenuItem item = new JMenuItem(action);
        if (action instanceof SearchTextAction) {
            item.setAccelerator(((SearchTextAction)action).ks);
        }
        return item;
    }

    private static final class SearchTextAction
    extends GlobalContextAction<TextSearchContext> {
        private final int id;
        private final KeyStroke ks;

        public SearchTextAction(String name, int id, KeyStroke ks) {
            super(TextSearchContext.class);
            this.id = id;
            this.ks = ks;
            this.putValue("Name", name);
        }

        @Override
        protected void actionPerformed(TextSearchContext context) {
            switch (this.id) {
                case 0: {
                    context.find();
                    break;
                }
                case 1: {
                    context.findNext();
                    break;
                }
                case 2: {
                    context.findPrevious();
                    break;
                }
                case 3: {
                    context.cancel();
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
    }
}

