/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.arguments;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class UIParams {
    public final Integer fontSize;
    public final List<URI> uris;
    public final List<String> commandLineOptions;
    public final boolean enableExperimentalFeatures;

    private UIParams(Builder builder) {
        this.fontSize = builder.fontSize;
        this.uris = UIParams.unmodifyableList(builder.uris);
        this.enableExperimentalFeatures = builder.enableExperimentalFeatures;
        this.commandLineOptions = UIParams.unmodifyableList(builder.commandLineOptions);
    }

    private static <T> List<T> unmodifyableList(List<T> list) {
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<URI> uris;
        private Integer fontSize;
        private List<String> commandLineOptions;
        private boolean enableExperimentalFeatures;

        private Builder() {
        }

        public UIParams build() {
            return new UIParams(this);
        }

        public Builder withFontSize(Integer fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public Builder withCommandLineOptions(List<String> commandLineOptions) {
            this.commandLineOptions = commandLineOptions;
            return this;
        }

        public Builder withURIs(List<URI> uris) {
            this.uris = uris;
            return this;
        }

        public Builder withExperimentalFeatures(boolean enableExperimentalFeatures) {
            this.enableExperimentalFeatures = enableExperimentalFeatures;
            return this;
        }
    }
}

