/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.model.PersistentModel;
import com.azul.log.gui.model.support.AbstractModel;

public class ChartTypeSelectorModel
extends AbstractModel
implements PersistentModel {
    private static final ChartTypeSelectorModel model = new ChartTypeSelectorModel();
    private static final CHART_TYPE DEFAULT = CHART_TYPE.LINE;
    private CHART_TYPE currentChartType = DEFAULT;

    public static ChartTypeSelectorModel getModel() {
        return model;
    }

    @Override
    public String getPersistentID() {
        return "ChartType";
    }

    @Override
    public void initFromExternalString(String data) {
        this.currentChartType = data == null ? DEFAULT : CHART_TYPE.valueOf(data);
    }

    @Override
    public String toExternalString() {
        return this.getPreferredPlotType().toString();
    }

    public void setPreferredPlotType(CHART_TYPE chartType) {
        this.currentChartType = chartType;
        this.fireChange();
    }

    public CHART_TYPE getPreferredPlotType() {
        return this.currentChartType;
    }

    public static enum CHART_TYPE {
        LINE,
        SCATTER;

    }
}

