/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.config.api.Config;
import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.support.AbstractModel;
import com.azul.log.gui.utils.UIUtils;
import com.azul.log.model.api.AbsoluteTimestamp;
import com.azul.log.model.api.LogTimeModel;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.utils.TextUtils;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DisplayTimeModel
extends AbstractModel {
    private static final String TIME_UNITS_PROPERTY = "DisplayTimeModel.Units";
    private static final String TZONE_PROPERTY = "DisplayTimeModel.TZone";
    private static final String USER_TIME_ZONE_ID_PROPERTY = "UserTimeZone";
    private static final DateTimeFormatter SIMPLE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter ZONED_FORMAT = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss z yyyy");
    private final AbsoluteTimestamp start_ts;
    private final ZoneId logZoneId;
    private ZoneId zoneId;

    private DisplayTimeModel(LogTimeModel logTimeModel) {
        this.start_ts = logTimeModel.getAbsoluteTimestampBase();
        TZone tzone = this.getTZone();
        this.logZoneId = logTimeModel.getTimeZoneId();
        if (tzone == TZone.FILE && this.logZoneId == null) {
            Logger.getLogger(DisplayTimeModel.class.getName()).log(Level.WARNING, "Cannot get TimeZone - falling back to the system time");
            this.setTZone(TZone.SYSTEM);
        }
        this.updateZoneId();
    }

    private static ZoneId getSystemZoneId() {
        return ZoneId.systemDefault();
    }

    private static ZoneId getUserZoneId() {
        return Optional.ofNullable(Config.getProperty(USER_TIME_ZONE_ID_PROPERTY)).map(ZoneId::of).orElse(DisplayTimeModel.getSystemZoneId());
    }

    public void setUserZoneId(ZoneId zoneId) {
        Config.setProperty(USER_TIME_ZONE_ID_PROPERTY, zoneId.getId());
        this.updateZoneId();
        this.fireChange();
    }

    public static DisplayTimeModel create(LogTimeModel logTimeModel) {
        return new DisplayTimeModel(logTimeModel);
    }

    private ZoneId getLogZoneId() {
        return Optional.ofNullable(this.logZoneId).orElse(ZoneId.systemDefault());
    }

    public String toString(AbsoluteTimestamp timestamp) {
        return this.toString(timestamp, ZONED_FORMAT);
    }

    public String toString(AbsoluteTimestamp timestamp, DateTimeFormatter formatter) {
        return timestamp.toString(formatter, this.zoneId);
    }

    public String toString(RelativeTimestamp timestamp) {
        return this.toString(timestamp, SIMPLE_FORMAT);
    }

    public String toString(RelativeTimestamp timestamp, DateTimeFormatter absTimeFormatter) {
        Units units = this.getUnits();
        if (units == Units.ABSOLUTE) {
            AbsoluteTimestamp abs = this.start_ts.shift((double)timestamp.getInUnits(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            return abs.toString(absTimeFormatter, this.zoneId);
        }
        return units.fromMillis(timestamp.getInUnits(TimeUnit.MILLISECONDS), true);
    }

    public Units getUnits() {
        return Config.getProperty(TIME_UNITS_PROPERTY, Units.SECONDS);
    }

    public void setUnits(Units units) {
        Config.setProperty(TIME_UNITS_PROPERTY, units);
        this.updateZoneId();
        this.fireChange();
    }

    public TZone getTZone() {
        return Config.getProperty(TZONE_PROPERTY, TZone.FILE);
    }

    public void setTZone(TZone tzone) {
        Config.setProperty(TZONE_PROPERTY, tzone);
        this.updateZoneId();
        this.fireChange();
    }

    private void updateZoneId() {
        switch (this.getTZone()) {
            case UTC: {
                this.zoneId = ZoneId.of("UTC");
                break;
            }
            case SYSTEM: {
                this.zoneId = DisplayTimeModel.getSystemZoneId();
                break;
            }
            case FILE: {
                this.zoneId = this.getLogZoneId();
                break;
            }
            case USER: {
                this.zoneId = DisplayTimeModel.getUserZoneId();
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    public static enum TZone {
        SYSTEM("Local System Time Zone"),
        FILE("Time Zone as in the GCLog"),
        UTC("UTC Time Zone"),
        USER("User Time Zone");

        private final String descr;

        private TZone(String descr) {
            this.descr = descr;
        }

        public String getDescription() {
            StringBuilder sb = new StringBuilder("Absolute Time: ");
            sb.append(this.descr);
            ZoneId zoneId = null;
            switch (this) {
                case SYSTEM: {
                    zoneId = DisplayTimeModel.getSystemZoneId();
                    break;
                }
                case FILE: {
                    zoneId = Optional.ofNullable(Context.lookup(LogTimeModel.class)).map(LogTimeModel::getTimeZoneId).orElse(ZoneId.systemDefault());
                    break;
                }
                case USER: {
                    zoneId = DisplayTimeModel.getUserZoneId();
                    break;
                }
            }
            if (this == UTC) {
                sb.append(" (Coordinated Universal Time, UTC)");
            } else if (zoneId != null) {
                OffsetDateTime odt = OffsetDateTime.ofInstant(Instant.now(), zoneId);
                String offset = odt.getOffset().toString();
                if ("Z".equals(offset)) {
                    offset = "";
                }
                sb.append(" (").append(zoneId.getDisplayName(TextStyle.FULL, Locale.US)).append(", UTC").append(offset).append(")");
            }
            return sb.toString();
        }
    }

    public static enum Units {
        ABSOLUTE(null),
        SECONDS("sec."),
        MINUTES("min."),
        HOURS("h."),
        AUTO("");

        private static final NumberFormat format;
        private final String suffix;

        private Units(String suffix) {
            this.suffix = suffix;
        }

        public String getDescription() {
            return TextUtils.toCamelCase(this.name().toLowerCase());
        }

        public TimeUnit toTimeUnit() {
            switch (this) {
                case SECONDS: {
                    return TimeUnit.SECONDS;
                }
                case MINUTES: {
                    return TimeUnit.MINUTES;
                }
                case HOURS: {
                    return TimeUnit.HOURS;
                }
            }
            throw new IllegalArgumentException();
        }

        public String fromMillis(long millis, boolean with_suffix) {
            if (ABSOLUTE == this) {
                return null;
            }
            if (AUTO == this) {
                StringBuilder sb = new StringBuilder();
                long remains = millis;
                int ms = (int)(remains % 1000L);
                int s = (int)((remains /= 1000L) % 60L);
                int m = (int)((remains /= 60L) % 60L);
                int h = (int)((remains /= 60L) % 24L);
                int d = (int)((remains /= 24L) % 7L);
                int w = (int)(remains /= 7L);
                if (w > 0) {
                    sb.append(w).append("w ");
                }
                if (w > 0 || d > 0) {
                    sb.append(d).append("d ");
                }
                sb.append(String.format("%02d", h)).append("h ");
                sb.append(String.format("%02d", m)).append("m ");
                sb.append(String.format("%02d", s)).append('.');
                sb.append(String.format("%02d", ms)).append('s');
                return sb.toString();
            }
            double factor = this.toTimeUnit().toMillis(1L);
            String res = format.format((double)millis / factor);
            return with_suffix ? res + " " + this.suffix : res;
        }

        static {
            format = UIUtils.getNumberFormat();
            format.setGroupingUsed(true);
            format.setMaximumFractionDigits(3);
            format.setMinimumFractionDigits(3);
        }
    }
}

