/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.model.PersistentModel;
import com.azul.log.gui.model.support.AbstractModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public final class GraphsSelectorModel
extends AbstractModel
implements PersistentModel {
    private static final GraphsSelectorModel model = new GraphsSelectorModel();
    public static final Action favoriteGraphs = new GraphsSelectorAction("Favorite Charts", Mode.FAVORITES);
    public static final Action allGraphs = new GraphsSelectorAction("All Charts", Mode.ALL);
    public static final Action scratchpad = new GraphsSelectorAction("Scratchpad", Mode.SCRATCHPAD);
    public static final EnumerateGraphsAction enumerateGraphsAction = new EnumerateGraphsAction("Enumerate Charts");
    private Mode active;
    private boolean enumerationEnabled = true;

    private GraphsSelectorModel() {
    }

    public static GraphsSelectorModel getModel() {
        return model;
    }

    public void setActiveMode(Mode mode) {
        this.active = mode;
        GraphsSelectorModel.updateActionsState();
        this.fireChange();
    }

    public Mode getActiveMode() {
        return this.active;
    }

    public boolean isEnumerationEnabled() {
        return this.enumerationEnabled;
    }

    @Override
    public String getPersistentID() {
        return "ActiveGraphsSelectorMode";
    }

    @Override
    public void initFromExternalString(String str) {
        Mode m = Mode.ALL;
        if (str != null && !str.isEmpty()) {
            String[] chunks = str.split(":");
            if (chunks.length > 0) {
                try {
                    m = Mode.valueOf(chunks[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (chunks.length > 1) {
                this.enumerationEnabled = Boolean.parseBoolean(chunks[1]);
            }
        }
        this.setActiveMode(m);
    }

    @Override
    public String toExternalString() {
        if (this.active == Mode.SCRATCHPAD) {
            throw new InternalError();
        }
        return String.join((CharSequence)":", this.active.name(), Boolean.toString(this.enumerationEnabled));
    }

    private static void updateActionsState() {
        favoriteGraphs.setEnabled(GraphsSelectorModel.model.active != Mode.FAVORITES);
        allGraphs.setEnabled(GraphsSelectorModel.model.active != Mode.ALL);
        scratchpad.setEnabled(GraphsSelectorModel.model.active != Mode.SCRATCHPAD);
        enumerateGraphsAction.setEnabled(GraphsSelectorModel.model.active == Mode.ALL);
    }

    public static enum Mode {
        ALL,
        FAVORITES,
        SCRATCHPAD;

    }

    public static class EnumerateGraphsAction
    extends AbstractAction {
        public EnumerateGraphsAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphsSelectorModel.model.enumerationEnabled = !GraphsSelectorModel.model.enumerationEnabled;
            model.fireChange();
        }

        public JMenuItem getMenuPresenter() {
            return new JCheckBoxMenuItem(this){

                @Override
                public boolean isSelected() {
                    return model.isEnumerationEnabled();
                }
            };
        }
    }

    private static class GraphsSelectorAction
    extends AbstractAction {
        private final Mode mode;

        public GraphsSelectorAction(String name, Mode mode) {
            super(name);
            this.mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            model.setActiveMode(this.mode);
        }
    }
}

