/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.model.api.LogLocation;
import com.azul.log.gui.model.spi.LogContentProvider;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogUnits;
import com.azul.log.model.api.RelativeTimestamp;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class UIElement
implements Lookup.Provider {
    protected final InstanceContent ic = new InstanceContent();
    private final RelativeTimestamp timestamp;
    private final int logLineNumber;
    private final Lookup lookup;
    private final LogModel logModel;
    private final LogContentProvider contentProvider;

    public UIElement(RelativeTimestamp timestamp, int logLineNumber, LogModel logModel) {
        this.timestamp = timestamp;
        this.logLineNumber = logLineNumber;
        this.logModel = logModel;
        this.lookup = new AbstractLookup(this.ic);
        this.contentProvider = logModel.lookup(LogContentProvider.class);
        if (this.contentProvider != null) {
            this.ic.add(this.contentProvider);
            LogLocation location = this.contentProvider.getLogLocation(logLineNumber);
            if (location != null) {
                this.ic.add(location);
            }
        }
    }

    public final RelativeTimestamp getTimestamp() {
        return this.timestamp.shift((double)this.logModel.getTimeAdjustmentNano(), LogUnits.NANOSECONDS);
    }

    public final RelativeTimestamp getRawTimestamp() {
        return this.timestamp;
    }

    public final int getLogLineNumber() {
        return this.logLineNumber;
    }

    public final String getLogLineContent() {
        return this.contentProvider == null ? "" : this.contentProvider.getLine(this.logLineNumber).toString();
    }

    @Override
    public final Lookup getLookup() {
        return this.lookup;
    }

    public LogModel getLogModel() {
        return this.logModel;
    }
}

