/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.SelectionController;
import com.azul.log.gui.model.UIElement;
import com.azul.log.gui.model.support.AbstractModel;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class UIElementSelectionModel
extends AbstractModel
implements Lookup.Provider {
    private static final UIElementSelectionModel instance = new UIElementSelectionModel();
    private final Lookup.Result<SelectionController> lookupResult;
    private final ProxyLookup.Controller lookupController = new ProxyLookup.Controller();
    private final Lookup lookup = new ProxyLookup(this.lookupController);
    private SelectionController<UIElement> controller = null;
    private UIElement selection = null;

    private UIElementSelectionModel() {
        this.lookupResult = Context.lookupResult(SelectionController.class);
        this.lookupResult.addLookupListener(e -> {
            this.controller = Context.lookup(SelectionController.class);
            this.fireChange();
        });
        this.fireChange();
    }

    public static UIElementSelectionModel getInstance() {
        return instance;
    }

    public UIElement getSelectedElement() {
        return this.selection;
    }

    public void setSelectedElement(UIElement element) {
        if (element == null) {
            this.clearSelection();
        } else if (!element.equals(this.selection)) {
            this.lookupController.setLookups(Lookups.singleton(element), element.getLookup());
            this.selection = element;
            this.fireChange();
        }
    }

    public void selectPrevious() {
        if (this.controller != null && this.controller.supports(this.selection)) {
            this.setSelectedElement(this.controller.getPrevious(this.selection));
        }
    }

    public void selectNext() {
        if (this.controller != null && this.controller.supports(this.selection)) {
            this.setSelectedElement(this.controller.getNext(this.selection));
        }
    }

    public void clearSelection() {
        if (this.selection != null) {
            this.lookupController.setLookups(Lookup.EMPTY);
            this.selection = null;
            this.fireChange();
        }
    }

    public boolean hasNext() {
        return this.controller != null && this.controller.supports(this.selection) && this.controller.hasNext(this.selection);
    }

    public boolean hasPrevious() {
        return this.controller != null && this.controller.supports(this.selection) && this.controller.hasPrevious(this.selection);
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    public void update(UIElement element) {
        this.lookupController.setLookups(Lookups.singleton(element), element.getLookup());
        this.fireChange();
    }
}

