/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.model.spi;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.spi.LogSummaryToUIModelConverterProvider;
import com.azul.log.model.api.LogModel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class LogSummaryToUIModelConverter {
    protected final LogModel logModel = Context.lookup(LogModel.class);
    private final List<WeakReference<? extends ChangeListener>> listeners = new ArrayList<WeakReference<? extends ChangeListener>>();

    public static LogSummaryToUIModelConverter create() {
        LogSummaryToUIModelConverterProvider provider = LogSummaryToUIModelConverterProvider.get();
        return provider == null ? null : provider.createConverter();
    }

    public final void convert(Callback callback) {
        this.convertImpl(callback);
        this.convertLogFilesInfo(callback);
    }

    protected abstract void convertImpl(Callback var1);

    protected void convertLogFilesInfo(Callback cb) {
        cb.addSection("Log Info");
        this.logModel.getPaths().forEach(p -> cb.addValue("Log File", this.logModel.getPaths()));
    }

    public final void addListener(ChangeListener changeListener) {
        this.listeners.add(new WeakReference<ChangeListener>(changeListener));
    }

    public final void removeListener(ChangeListener changeListener) {
        Iterator<WeakReference<? extends ChangeListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            WeakReference<? extends ChangeListener> ref = it.next();
            ChangeListener listener = (ChangeListener)ref.get();
            if (listener != changeListener) continue;
            it.remove();
            break;
        }
    }

    protected void fireChange(ChangeEvent evt) {
        Iterator<WeakReference<? extends ChangeListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            WeakReference<? extends ChangeListener> ref = it.next();
            ChangeListener listener = (ChangeListener)ref.get();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.stateChanged(evt);
        }
    }

    public static abstract class Callback {
        protected final String NA = "n/a";

        public abstract void addSection(String var1);

        public abstract void addIndent();

        public abstract void addValue(String var1, Object var2);

        public void addValueIfPresent(String name, Object value) {
            if (value != null) {
                this.addValue(name, value);
            }
        }

        public <T> void addValue(String name, T obj, Function<T, String> converter) {
            this.addValue(name, obj == null ? "n/a" : converter.apply(obj));
        }

        public <T> void addValueIfPresent(String name, T obj, Function<T, String> converter) {
            String v;
            String string = v = obj == null ? null : converter.apply(obj);
            if (v != null) {
                this.addValue(name, v);
            }
        }

        public void addValues(String name, List<?> values) {
            if (values != null && !values.isEmpty()) {
                String n = name;
                for (Object v : values) {
                    this.addValue(n, v.toString());
                    n = "";
                }
            } else {
                this.addValue(name, "n/a");
            }
        }
    }
}

