/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.search;

import com.azul.log.gui.model.spi.LogContentProvider;
import com.azul.log.gui.search.SearchProgressListener;
import com.azul.log.gui.search.SearchTaskContinuation;
import com.azul.log.gui.ui.TextSearchPanel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public final class LogTextSearchTask {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private final SearchWorker worker;

    private LogTextSearchTask(LogContentProvider contentProvider, int startLine, SearchDirection direction, TextSearchPanel searchPanel, SearchTaskContinuation continuation) {
        this.worker = new SearchWorker(contentProvider, startLine, direction, searchPanel, continuation);
        if (searchPanel != null) {
            searchPanel.startProgress(contentProvider.getLinesCount());
        }
        this.worker.execute();
    }

    public static LogTextSearchTask submit(LogContentProvider contentProvider, int startLine, SearchDirection direction, TextSearchPanel searchPanel, SearchTaskContinuation continuation) {
        return new LogTextSearchTask(contentProvider, startLine, direction, searchPanel, continuation);
    }

    public void cancel() {
        this.worker.cancel();
    }

    private static final class ProgressTracker {
        private final SearchProgressListener listener;
        private final AtomicInteger progress = new AtomicInteger(0);

        public ProgressTracker(SearchProgressListener listener) {
            this.listener = listener;
        }

        public void setProgress(int value) {
            if (this.listener != null) {
                int current;
                while ((current = this.progress.get()) < value) {
                    if (!this.progress.compareAndSet(current, value)) continue;
                    this.listener.setProgress(value);
                    break;
                }
            }
        }
    }

    private static final class SearchUsingContentProvider
    extends SearchAlgorithm {
        public SearchUsingContentProvider(LogContentProvider contentProvider, int startLine, SearchDirection direction, AtomicBoolean interrupt, ProgressTracker tracker, TextSearchPanel searchPanel) {
            super(contentProvider, startLine, direction, interrupt, tracker, searchPanel);
        }

        @Override
        protected int start() {
            int linesCount = this.contentProvider.getLinesCount();
            int lineIncrement = this.direction == SearchDirection.FORWARD ? 1 : -1;
            int line = this.startLine + lineIncrement;
            while (!this.interrupted.get() && line != this.startLine) {
                CharSequence lineContent;
                if ((this.progress++ & 0x3FFF) == 0) {
                    this.tracker.setProgress(this.progress);
                }
                if ((lineContent = this.contentProvider.getLine(line)) == null) {
                    if (!Thread.interrupted()) continue;
                    this.interrupted.set(true);
                    continue;
                }
                boolean matchFound = true;
                String rawLine = this.searchPanel.isCaseSensitive() ? lineContent.toString() : lineContent.toString().toUpperCase();
                List<Function<String, Boolean>> searchFilters = this.searchPanel.getSearchFilters();
                for (Function<String, Boolean> searchFilter : searchFilters) {
                    if (searchFilter.apply(rawLine).booleanValue()) continue;
                    matchFound = false;
                    break;
                }
                if (matchFound) {
                    return line;
                }
                if ((line += lineIncrement) < 1) {
                    line = linesCount;
                }
                if (line > linesCount) {
                    line = 1;
                }
                if (!Thread.interrupted()) continue;
                this.interrupted.set(true);
            }
            return -1;
        }
    }

    private static abstract class SearchAlgorithm
    implements Callable<Integer> {
        protected final SearchDirection direction;
        protected final AtomicBoolean interrupted;
        protected final int startLine;
        protected final LogContentProvider contentProvider;
        protected final ProgressTracker tracker;
        protected final TextSearchPanel searchPanel;
        protected int progress;

        protected SearchAlgorithm(LogContentProvider contentProvider, int startLine, SearchDirection direction, AtomicBoolean interrupt, ProgressTracker tracker, TextSearchPanel searchPanel) {
            this.contentProvider = contentProvider;
            this.direction = direction;
            this.startLine = startLine;
            this.interrupted = interrupt;
            this.tracker = tracker;
            this.progress = 0;
            this.searchPanel = searchPanel;
        }

        @Override
        public Integer call() {
            long start_time = System.currentTimeMillis();
            int result = this.start();
            long end_time = System.currentTimeMillis();
            if (Thread.interrupted()) {
                this.interrupted.set(true);
            }
            Logger.getLogger(SearchAlgorithm.class.getName()).fine(String.format("%s: Search completed in %d ms. [interrupted: %b]", this.getClass().getSimpleName(), end_time - start_time, this.interrupted.get()));
            return result;
        }

        protected abstract int start();
    }

    private static final class SearchWorker
    extends SwingWorker<Integer, String> {
        private final LogContentProvider contentProvider;
        private final int startLine;
        private final SearchDirection direction;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicBoolean interrupt = new AtomicBoolean(false);
        private final TextSearchPanel searchPanel;
        private final SearchTaskContinuation continuation;

        private SearchWorker(LogContentProvider contentProvider, int startLine, SearchDirection direction, TextSearchPanel searchPanel, SearchTaskContinuation continuation) {
            this.contentProvider = contentProvider;
            this.startLine = startLine;
            this.direction = direction;
            this.searchPanel = searchPanel;
            this.continuation = continuation;
        }

        public void cancel() {
            this.cancelled.set(true);
            this.interrupt.set(true);
        }

        @Override
        protected Integer doInBackground() throws Exception {
            ProgressTracker tracker = new ProgressTracker(this.searchPanel);
            SearchUsingContentProvider algorithm1 = new SearchUsingContentProvider(this.contentProvider, this.startLine, this.direction, this.interrupt, tracker, this.searchPanel);
            Integer line = (Integer)executor.invokeAny(Collections.singletonList(algorithm1));
            this.interrupt.set(true);
            return line;
        }

        @Override
        protected void done() {
            if (this.searchPanel != null) {
                this.searchPanel.stopProgress();
            }
            if (this.continuation != null && !this.cancelled.get()) {
                try {
                    this.continuation.lineFound((Integer)this.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        }
    }

    public static enum SearchDirection {
        FORWARD,
        BACKWARD;

    }
}

