/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.search;

import com.azul.log.gui.model.Context;
import com.azul.log.gui.model.TimeRangeSelectionModel;
import com.azul.log.gui.ui.TextSearchPanel;
import com.azul.log.model.api.LogModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public final class TableFilterer<M extends TableModel>
extends TableRowSorter<M> {
    private final List<Integer> viewToModel;
    private final List<Integer> modelToView;
    private final TextSearchPanel searchPanel;
    private final Runnable refreshTableAction;
    private final LogModel logModel;
    private final TimeRangeSelectionModel.VisibleTimeRangeModel visibleTimeRangeModel;
    private final AtomicBoolean interrupt;

    public TableFilterer(M model, TextSearchPanel searchPanel, Runnable refreshTableAction) {
        super(model);
        this.searchPanel = searchPanel;
        this.refreshTableAction = refreshTableAction;
        this.viewToModel = Collections.synchronizedList(new ArrayList());
        this.modelToView = Collections.synchronizedList(new ArrayList());
        this.interrupt = new AtomicBoolean(false);
        this.logModel = Context.lookup(LogModel.class);
        this.visibleTimeRangeModel = Context.lookup(TimeRangeSelectionModel.VisibleTimeRangeModel.class);
    }

    public void filter() {
        this.interrupt.set(false);
        int rowCount = this.getModelWrapper().getRowCount();
        Timer timer = new Timer(true);
        this.viewToModel.clear();
        this.modelToView.clear();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(() -> TableFilterer.this.refreshTableAction.run());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS.toMillis(1L));
        int viewCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            this.searchPanel.setProgress(i);
            if (this.interrupt.get()) {
                timer.cancel();
                return;
            }
            if (this.include(i)) {
                this.viewToModel.add(i);
                this.modelToView.add(viewCount++);
                continue;
            }
            this.modelToView.add(-1);
        }
        timer.cancel();
    }

    private boolean isFilteringEnabled() {
        return this.searchPanel.applyFiltering();
    }

    @Override
    public int getModelRowCount() {
        return this.getModelWrapper().getRowCount();
    }

    @Override
    public int getViewRowCount() {
        if (this.isFilteringEnabled()) {
            return this.viewToModel.size();
        }
        return this.getModelWrapper().getRowCount();
    }

    @Override
    public int convertRowIndexToView(int index) {
        return this.modelToView.get(index);
    }

    @Override
    public int convertRowIndexToModel(int index) {
        if (this.isFilteringEnabled()) {
            try {
                return this.viewToModel.get(index);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return index;
    }

    private boolean include(int row) {
        return this.isRowWithinSliderRange(row) && this.isTextPresentInRow(row);
    }

    private boolean isRowWithinSliderRange(int logLineNumber) {
        if (this.visibleTimeRangeModel.isWholeRange()) {
            return true;
        }
        long sliderStart = this.visibleTimeRangeModel.getSelection().getStart().getInUnits(TimeUnit.SECONDS);
        long sliderEnd = this.visibleTimeRangeModel.getSelection().getEnd().getInUnits(TimeUnit.SECONDS);
        long minLineNumber = this.logModel.getClosestMatchingLogLineForGivenTime(sliderStart);
        long maxLineNumber = this.logModel.getClosestMatchingLogLineForGivenTime(sliderEnd);
        return (long)logLineNumber >= minLineNumber && (long)logLineNumber <= maxLineNumber;
    }

    private boolean isTextPresentInRow(int row) {
        String rawLine = (String)((TableModel)this.getModel()).getValueAt(row, 0);
        if (!this.searchPanel.isCaseSensitive()) {
            rawLine = rawLine.toUpperCase();
        }
        List<Function<String, Boolean>> filters = this.searchPanel.getSearchFilters();
        for (Function<String, Boolean> filter : filters) {
            if (filter.apply(rawLine).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.interrupt.set(true);
        this.refreshTableAction.run();
    }

    @Override
    public void sort() {
    }

    @Override
    public boolean isSortable(int column) {
        return false;
    }

    @Override
    public void setRowFilter(RowFilter<? super M, ? super Integer> filter) {
        this.raiseUnsupportedOperationException();
    }

    @Override
    public void toggleSortOrder(int column) {
        this.raiseUnsupportedOperationException();
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
        super.setSortKeys(null);
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return Collections.emptyList();
    }

    private void raiseUnsupportedOperationException() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support this operation");
    }
}

