/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.support;

import com.azul.log.gui.model.LogLineOffsetMap;
import com.azul.log.gui.model.api.LogLocation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LogFilesSupport {
    private LogFilesSupport() {
    }

    public static final class LogFilesMappingInfo {
        private final List<Path> paths;
        private final LogLineOffsetMap lineOffsetMap;
        private final int[] firstLineNumbers;
        private int maxLengthLineNumber;
        private int maxLength;

        LogFilesMappingInfo(List<Path> paths) {
            this.paths = Collections.unmodifiableList(new ArrayList<Path>(paths));
            this.lineOffsetMap = new LogLineOffsetMap();
            this.firstLineNumbers = new int[paths.size()];
            this.setFirstLineNumber(0, 1);
        }

        public List<Path> getPaths() {
            return this.paths;
        }

        public int getMaxLengthLineNumber() {
            return this.maxLengthLineNumber;
        }

        public int getLinesCount() {
            return this.lineOffsetMap.size();
        }

        public LogLineOffsetMap.FileOffset getFileOffset(int lineNumber) {
            return this.lineOffsetMap.getFileOffset(lineNumber);
        }

        void updateMaxLineLength(int lineNumber, int length) {
            if (this.maxLength < length) {
                this.maxLength = length;
                this.maxLengthLineNumber = lineNumber;
            }
        }

        void setFirstLineNumber(int currentFileIdx, int lineNumber) {
            this.firstLineNumbers[currentFileIdx] = lineNumber;
        }

        void addLineOffset(int fileIndex, long offsetInFile) {
            this.lineOffsetMap.push(fileIndex, offsetInFile);
        }

        public LogLocation getLogLocation(int lineNumber) {
            if (lineNumber < 1 || lineNumber > this.lineOffsetMap.size()) {
                return null;
            }
            LogLineOffsetMap.FileOffset offset = this.lineOffsetMap.getFileOffset(lineNumber);
            int file_idx = offset.getFileIndex();
            Path path = this.paths.get(file_idx);
            return new LogLocation(path, 1 + lineNumber - this.firstLineNumbers[file_idx]);
        }
    }
}

