/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.support;

import com.azul.log.gui.ui.MainFrame;
import com.azul.log.parser.spi.UserInteractionHandler;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public final class UIInteractionHandler
implements UserInteractionHandler {
    @Override
    public UserInteractionHandler.Response confirm(String title, String question) {
        int answer = JOptionPane.showConfirmDialog(MainFrame.get(), question, title, 1, 3);
        switch (answer) {
            case 1: {
                return UserInteractionHandler.Response.NO;
            }
            case 0: {
                return UserInteractionHandler.Response.YES;
            }
            case -1: 
            case 2: {
                return UserInteractionHandler.Response.CANCEL;
            }
        }
        throw new InternalError("Unhandled option " + answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runTaskAroundProgressDialog(Runnable task, String message) {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        JOptionPane pane = new JOptionPane(new Object[]{message, "Please wait ...", progressBar}, 1, -1, null, new Object[0], null);
        JDialog progressDialog = pane.createDialog(MainFrame.get(), "Time consuming task ...");
        if (Objects.nonNull(task)) {
            progressDialog.setModal(false);
            progressDialog.setAlwaysOnTop(true);
            progressDialog.setDefaultCloseOperation(0);
            progressDialog.setFocusable(true);
            progressDialog.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    e.consume();
                }
            });
            progressDialog.toFront();
            progressDialog.setVisible(true);
            try {
                task.run();
            }
            catch (Exception e) {
                progressDialog.dispose();
                boolean bl = false;
                return bl;
            }
            finally {
                progressDialog.dispose();
            }
        }
        return true;
    }
}

