/*
 * Decompiled with CFR 0.152.
 */
package com.azul.log.gui.tables.api;

import com.azul.log.gui.support.RecordFieldTooltipSupport;
import com.azul.log.gui.tables.api.annotations.TableDescription;
import com.azul.log.model.api.LogModel;
import com.azul.log.model.api.LogRecord;
import com.azul.log.model.api.LogRecordsList;
import com.azul.log.model.api.RelativeTimestamp;
import com.azul.log.parser.utils.Cache;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.table.AbstractTableModel;

public final class TableDefinition
extends AbstractTableModel {
    private final int id;
    private final TableDescription descr;
    private final LogRecordsList<? extends LogRecord> data;
    private final Cache<Integer, Object[]> cache;
    private final List<Field> fields;
    private final LogModel logModel;

    TableDefinition(LogModel logModel, TableDescription descr, LogRecordsList<? extends LogRecord> data) {
        this.logModel = logModel;
        this.descr = descr;
        this.data = data;
        this.id = this.getTitle().hashCode();
        this.cache = Cache.create("TableDefinition " + this.getTitle());
        this.fields = data.isEmpty() ? Collections.emptyList() : data.get(0).getAllFields();
    }

    public String getTitle() {
        return this.descr.title();
    }

    public int getID() {
        return this.id;
    }

    public LogRecordsList<? extends LogRecord> getTableData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data.hasData();
    }

    public int getPosition() {
        return this.descr.position();
    }

    public LogRecord getRecord(int idx) {
        return this.data.get(idx);
    }

    public int getRowWithoutTimestamp(int row) {
        LogRecord record;
        int idx = 0;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext() && (record = (LogRecord)iterator.next()).getLogLineNumber() != row) {
            ++idx;
        }
        return idx;
    }

    public int getClosestRow(RelativeTimestamp logRelativeTimestamp) {
        LogRecord record;
        int idx = 0;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext() && (record = (LogRecord)iterator.next()).getEventRelativeTimestamp().compareTo(logRelativeTimestamp) < 0) {
            ++idx;
        }
        return idx;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.fields.size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.data.get(rowIndex).getLogRelativeTimestamp();
        }
        Object[] values = this.getRecordValues(rowIndex);
        return values == null ? null : values[columnIndex - 1];
    }

    public String getValueTooltipAt(int rowIndex, int columnIndex) {
        if (columnIndex < 0) {
            return null;
        }
        LogRecord record = this.data.get(rowIndex);
        if (columnIndex == 0) {
            return record.getLogRelativeTimestamp().getInUnits(TimeUnit.SECONDS) + " sec.";
        }
        Field field = this.fields.get(columnIndex - 1);
        return RecordFieldTooltipSupport.getHTMLTooltip(record, field);
    }

    private Object[] getRecordValues(int rowIndex) {
        return this.cache.computeIfAbsent(rowIndex, idx -> {
            LogRecord record = this.data.get(rowIndex);
            return this.fields.stream().map(record::getFieldValue).toArray();
        });
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Timestamp";
        }
        Field fld = this.fields.get(columnIndex - 1);
        LogRecord record = this.data.get(0);
        return record.getFieldDescription(fld).name();
    }

    public String getColumnTooltip(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.data.isEmpty()) {
            return Object.class;
        }
        return columnIndex == 0 ? RelativeTimestamp.class : this.fields.get(columnIndex - 1).getType();
    }

    public LogModel getLogModel() {
        return this.logModel;
    }
}

